// {$R WWW_Usage.JFM}

/* WWW_Usage.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    address:
           9526 Judson Rd.
           Ravenna, MI 49451
 *
 * Version 1.0.0
 *    original
 * Version 1.0.1
 *    added ability to run as application
 *    added parameters
 * Version 1.1.1
 *    added bytesRead to WWWTransfer
 * Version 1.1.2
 *    allowed clicking on legends in pie charts
 */

import InfoFrame;
import Filters;
import QSortAlgorithm;
import OptionsFrame;
import GraphCanvas;
import LogFrame;
import WWWParser;
import WWWTransfer;

import java.awt.*;
import java.applet.*;
import java.util.*;
import java.net.*;
import java.io.*;

class UsageControlPanel extends Panel {
    //Dimension dim=new Dimension(84,236);
    public Dimension minimumSize() {
        Dimension dimmer=super.minimumSize();
        dimmer.width=(int)((double)(dimmer.width)*0.8);
        return dimmer;
    }
    
    public Dimension preferredSize() { 
        return minimumSize();
        //return new Dimension(116,324); 
    }
}

class ApplicationFrame extends Frame {
    ApplicationFrame(String t) { super(t); setIconImage(getToolkit().getImage("images/icon.gif")); }
    public boolean handleEvent(Event evt)
    {
        // handleEvent()
        if (evt.id == Event.WINDOW_DESTROY && evt.target == this) WindowDestroy(evt.target);
        return super.handleEvent(evt);
    }

    public void WindowDestroy(Object target) {
        System.exit(0);
    }
}

// Class WWW_Usage
public class WWW_Usage extends Applet implements Runnable, ThreadKeeper, FontSetting
{
    public boolean keepRunning = true;
    
    final int MenuBarHeight = 0;

    // Component Declaration
    public GraphPanel graphPanel;
    public Label loadingLabel;
    public UsageControlPanel controlPanel;
    public Panel typePanel;
    public CheckboxGroup CheckboxGrpIntypePanel;
    public Checkbox pieButton;
    public Checkbox lineButton;
    public Label Label1;
    public Label Label2;
    public Choice showChoice;
    public Label Label3;
    public Button infoButton;
    public Button filterButton;
    public Button optionButton;
    public Choice catChoice;
    public Checkbox barButton;
    public Panel statusPanel;
    public TextField statusField;
    // End of Component Declaration

    public Filters filterFrame;
    WWWParser myParser;
    public InfoFrame infoFrame;
    boolean loaded;
    public boolean application=false;

    boolean infoShown=false;
    boolean filtersShown=false;
    public String arg1;
    
    Thread loaderThread=null;
    
    public static String versionString="1.2.0(Beta-4) Nov, 15 1997";

    String fontName="Dialog";
    int fontSize=10;

    public boolean getKeepRunning() { return keepRunning; }
    public TextField getStatusField() { return statusField; }

    public void setInterfaceFont(String name, int size)
    {
        fontName=name;
        fontSize=size;
        Label1.setFont(new Font(name, Font.BOLD, size));
        Label2.setFont(new Font(name, Font.BOLD, size));
        Label3.setFont(new Font(name, Font.BOLD, size));
        catChoice.setFont(new Font(name, Font.PLAIN, size));
        pieButton.setFont(new Font(name, Font.PLAIN, size));
        lineButton.setFont(new Font(name, Font.PLAIN, size));
        barButton.setFont(new Font(name, Font.PLAIN, size));
        showChoice.setFont(new Font(name, Font.PLAIN, size));
        optionButton.setFont(new Font(name, Font.PLAIN, size));
        filterButton.setFont(new Font(name, Font.PLAIN, size));
        infoButton.setFont(new Font(name, Font.PLAIN, size));
        statusField.setFont(new Font(name, Font.PLAIN, size));
        layout(); validate(); 
        graphPanel.myCanvas.setChanged(true);
    }

    public String getInterfaceFontName() { return fontName; }
    
    public int getInterfaceFontSize() { return fontSize; }

    // init()
    public void init()
    {
        GridBagLayout gridbag=new GridBagLayout();
        GridBagConstraints gridCons=new GridBagConstraints();

        GlobalVillage.appl=(application ? null : this);
        GlobalVillage.iconImage=application ? getToolkit().getImage("images/icon.gif") : getImage(getCodeBase(), "images/icon.gif");
        GlobalVillage.wwwUsage=this;
        
        // Frame Initialization
        setForeground(Color.black);
        setBackground(Color.white);
        setFont(new Font("Dialog",Font.BOLD,12));
        setLayout(new BorderLayout(5,5));
        // End of Frame Initialization

        // Component Initialization
        graphPanel = new GraphPanel();
        graphPanel.setLayout(new FlowLayout());
        graphPanel.setForeground(Color.red);
        graphPanel.setBackground(Color.white);
        graphPanel.setFont(new Font("Dialog",Font.BOLD,12));
        loadingLabel = new Label("Loading www_transfers log...",Label.LEFT);
        loadingLabel.setFont(new Font("Dialog",Font.BOLD,12));
        controlPanel = new UsageControlPanel();
        controlPanel.setLayout(gridbag);
        controlPanel.setForeground(Color.black);
        controlPanel.setBackground(Color.orange);
        controlPanel.setFont(new Font("Dialog",Font.BOLD,12));
        typePanel = new Panel();
        typePanel.setLayout(new GridLayout(3,1,0,0));
        typePanel.setForeground(Color.black);
        typePanel.setBackground(Color.orange);
        typePanel.setFont(new Font("Dialog",Font.BOLD,12));
        CheckboxGrpIntypePanel = new CheckboxGroup(); // CheckboxGroup in typePanel
        pieButton = new Checkbox("pie",CheckboxGrpIntypePanel,false);
        pieButton.setBackground(Color.orange);
        pieButton.setFont(new Font("Dialog",Font.PLAIN,10));
        lineButton = new Checkbox("line",CheckboxGrpIntypePanel,true);
        lineButton.setBackground(Color.orange);
        lineButton.setFont(new Font("Dialog",Font.PLAIN,10));
        Label1 = new Label("Categories",Label.LEFT);
        Label1.setFont(new Font("Dialog",Font.BOLD,10));
        Label2 = new Label("Chart Type",Label.LEFT);
        Label2.setFont(new Font("Dialog",Font.BOLD,10));
        showChoice = new Choice();
        showChoice.addItem("All Weeks");
        showChoice.addItem("Average Week");
        showChoice.setFont(new Font("Dialog",Font.PLAIN,10));
        Label3 = new Label("Show",Label.LEFT);
        Label3.setFont(new Font("Dialog",Font.BOLD,10));
        infoButton = new Button("Info...");
        infoButton.setFont(new Font("Dialog",Font.PLAIN,10));
        filterButton = new Button("Filters...");
        filterButton.setFont(new Font("Dialog",Font.PLAIN,10));
        optionButton = new Button("Options...");
        optionButton.setFont(new Font("Dialog",Font.PLAIN,10));
        catChoice = new Choice(); /*
        catChoice.addItem("Accesses");
        catChoice.addItem("Domains");
        catChoice.addItem("Sites");
        catChoice.addItem("Items");
        catChoice.addItem("Clients");
        catChoice.addItem("KBytes");
        catChoice.addItem("Referers"); */
        catChoice.setFont(new Font("Dialog",Font.PLAIN,10));
        barButton = new Checkbox("bar",CheckboxGrpIntypePanel,false);
        barButton.setBackground(Color.orange);
        barButton.setFont(new Font("Dialog",Font.PLAIN,10));
        statusPanel = new Panel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setForeground(Color.black);
        statusPanel.setBackground(Color.pink);
        statusPanel.setFont(new Font("Dialog",Font.BOLD,12));
        statusField = new TextField("");
        statusField.setForeground(Color.black);
        statusField.setBackground(Color.white);
        statusField.setFont(new Font("Dialog",Font.PLAIN,10));
        // End of Component Initialization

        setInterfaceFont(fontName, fontSize);

        // can be changed to allow commands to be typed in
        statusField.setEditable(false);

        if(application)
            infoFrame=new InfoFrame("WWW Usage", versionString);
        else
            infoFrame=new InfoFrame("WWW Usage", versionString);

    /*** Label1 */
        gridCons.anchor=GridBagConstraints.SOUTHWEST;
        gridCons.fill=GridBagConstraints.NONE;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(0,0,0,0);
        gridCons.ipadx=0;
        gridCons.ipady=0;
        gridCons.weighty=1;
        gridCons.weightx=4;
    /*** Label1 */
        gridbag.setConstraints(Label1,gridCons);

    /*** catChoice */
        gridCons.anchor=GridBagConstraints.WEST;
        gridCons.fill=GridBagConstraints.BOTH;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(1,1,2,1);
        gridCons.ipadx=0;
        gridCons.ipady=0;
        gridCons.weightx=1;
    /*** catChoice */

        gridbag.setConstraints(catChoice,gridCons);

    /*** Label2 */
        gridCons.anchor=GridBagConstraints.SOUTHWEST;
        gridCons.fill=GridBagConstraints.NONE;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(0,0,0,0);
        gridCons.ipadx=0;
        gridCons.ipady=0;
        gridCons.weightx=4;
    /*** Label2 */

        gridbag.setConstraints(Label2,gridCons);

    /*** typePanel */
        gridCons.anchor=GridBagConstraints.WEST;
        gridCons.fill=GridBagConstraints.BOTH;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(1,1,1,1);
        gridCons.ipadx=0;
        gridCons.ipady=0;
        gridCons.weighty=0;
        gridCons.weightx=0;
    /*** typePanel */

        gridbag.setConstraints(typePanel,gridCons);

    /*** Label3 */
        gridCons.anchor=GridBagConstraints.SOUTHWEST;
        gridCons.fill=GridBagConstraints.NONE;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(0,0,0,0);
        gridCons.ipadx=0;
        gridCons.ipady=0;
        gridCons.weighty=1;
        gridCons.weightx=4;
    /*** Label3 */

        gridbag.setConstraints(Label3,gridCons);

    /*** showChoice */
        gridCons.anchor=GridBagConstraints.WEST;
        gridCons.fill=GridBagConstraints.BOTH;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(1,1,2,1);
        gridCons.ipadx=0;
        gridCons.ipady=0;
        gridCons.weightx=1;
    /*** showChoice */

        gridbag.setConstraints(showChoice,gridCons);

    /*** optionButton */
        gridCons.anchor=GridBagConstraints.CENTER;
        gridCons.fill=GridBagConstraints.BOTH;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(1,1,1,1);
        gridCons.ipadx=1;
        gridCons.ipady=2;
        gridCons.weighty=0;
        gridCons.weightx=0;
    /*** optionButton */

        gridbag.setConstraints(optionButton,gridCons);

    /*** filterButton */
        gridCons.anchor=GridBagConstraints.CENTER;
        gridCons.fill=GridBagConstraints.BOTH;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(1,1,1,1);
        gridCons.ipadx=1;
        gridCons.ipady=2;
        gridCons.weightx=0;
    /*** filterButton */

        gridbag.setConstraints(filterButton,gridCons);

    /*** infoButton */
        gridCons.anchor=GridBagConstraints.CENTER;
        gridCons.fill=GridBagConstraints.BOTH;
        gridCons.gridheight=1;
        gridCons.gridwidth=GridBagConstraints.REMAINDER;
        gridCons.insets=new Insets(1,1,1,1);
        gridCons.ipadx=1;
        gridCons.ipady=2;
        gridCons.weightx=0;
    /*** infoButton */

        gridbag.setConstraints(infoButton,gridCons);

        // Add()s
        statusPanel.add("Center", statusField);
        add("South", statusPanel);
        typePanel.add(barButton);
        controlPanel.add(Label1);
        controlPanel.add(catChoice);
        typePanel.add(pieButton);
        typePanel.add(barButton);
        typePanel.add(lineButton);
        controlPanel.add(Label2);
        controlPanel.add(typePanel);
        controlPanel.add(Label3);
        controlPanel.add(showChoice);
        controlPanel.add(optionButton);
        controlPanel.add(filterButton);
        controlPanel.add(infoButton);
        graphPanel.add(loadingLabel);
        add("East", controlPanel);
        add("Center", graphPanel);
        // End of Add()s

   //     InitialPositionSet();
    } // End of init()

    private Color getColorParameter(String name)
    {
        String param;
        Color ret=null;
            Color tC;
            int t, size, style; 
            int r,g,b;
            String t1, t2, t3, t4;
            StringTokenizer toker;
        
            param=getParameter(name);
            if(param!=null) {
                tC=Color.getColor(param);
                if(tC!=null) {
                    ret=tC;
                } else {
                    toker=new StringTokenizer(param," ");
                    try {
                        t1=toker.nextToken();
                        t2=toker.nextToken();
                        t3=toker.nextToken();
                        r=Integer.parseInt(t1);
                        g=Integer.parseInt(t2);
                        b=Integer.parseInt(t3);
                        ret=(new Color(r,g,b));
                    } catch(Exception e) {
                        System.out.println("error parsing "+param+" : "+e.getMessage());
                    }
                }
            }
            return ret;
    }

    private boolean getBooleanParameter(String name)
    {
        String param;
        boolean ret=false;
        
            param=getParameter(name);
            if(param!=null) {
                try {
                    ret=(new Boolean(param)).booleanValue();
                } catch(Exception e) {
                    System.out.println("Malformed parameter "+name+": "+e.getMessage());
                }
            }
        return ret;
    }
    
    private int getIntParameter(String name)
    {
        String param;
        int ret=0;
        
            param=getParameter(name);
            if(param!=null) {
                try {
                    ret=Integer.parseInt(param);
                } catch(Exception e) {
                    System.out.println("Malformed parameter "+name+": "+e.getMessage());
                }
            }
        return ret;
    }
    
    private Font getFontParameter(String name, String size, String bold, String italic)
    {
            int t, tsize, style; 
            int r,g,b;
            Font ret=null;
            Font tF;
            String t1, t2, t3, t4;
            StringTokenizer toker;
            
            t1=getParameter(name);
            t2=getParameter(size);
            t3=getParameter(bold);
            t4=getParameter(italic);

            if(t1!=null && t2!=null) {
                try {
                    tsize=Integer.parseInt(t2);
                    style=Font.PLAIN;
                    if(t3!=null) {
                        if((new Boolean(t3)).booleanValue())
                            style+=Font.BOLD;
                    }
                    if(t4!=null) {
                        if((new Boolean(t4)).booleanValue())
                            style+=Font.ITALIC;
                    }
                    ret=(new Font(t1, style, tsize));
                } catch(Exception e) {
                    System.out.println("Malformed parameter "+name+" "+size+" "+bold+" "+italic+": "+e.getMessage());
                }
            }
            return ret;
    }
    
    synchronized public void start()
    {
        System.out.println("WWW_Usage.start: started on "+(new Date()).toString());
        if(loaded) return;
        loaded=true;
        keepRunning=true;
            loaderThread=new Thread(this);
            loaderThread.start();
    }
    
    public void run() {
        System.out.println("WWW_Usage.run: started on "+(new Date()).toString());
    
        String param;
        String server, codeBase, fileName;
        URL fileURL=null;
        int loop, weeks;
        boolean filterFiles=true, filterSites=true;
        Vector fFilters, sFilters;
        String fFilterStrings=".gif, .jpg, .jpeg, www_transfers, .class, .css";
        String sFilterStrings="";
        StringTokenizer toker;
        boolean sortLog=false;
        int logFormat=WWWTransfer.LOG_COMBINED;        
    
        boolean showAccesses=true;
        boolean showDomains=true;
        boolean showSites=true;
        boolean showRFC931=true;
        boolean showAuthUser=true;
        boolean showItems=true;
        boolean showUserAgents=true;
        boolean showKBytes=true;
        boolean showReferers=true;
        boolean showCodes=true;
        
        boolean categorizeUA=false;

        boolean hideControlPanel=false;
        boolean hideStatusField=false;
        
        String display=null;
        
        String collapseItems=null;
        
        String ifName=fontName;
        int ifSize=fontSize;

        //if(loaded) return;

        // if(!loaded) {
            graphPanel.disable();
            controlPanel.disable();
        
            if(!application) {
                showStatus("loading www_transfers_log...");
                param=getParameter("WWWURL");             
            }
            else {
                param=arg1;
            
                if(param==null) {
                    Properties sysProp=System.getProperties();
                    try { 
                        param="file:///"+sysProp.getProperty("user.dir")+"/www_transfers";
                    } catch(Exception e) {
                        System.out.println(e.getMessage());
                        param="www_transfers";
                    }
                }
            } // application
            if(param!=null) {
                try {
                    fileURL=new URL(param);
                } catch(MalformedURLException e) {
                    System.out.println(e.getMessage());
                    fileURL=null;
                }
            } // param!=null
            else {
                try {
                    fileURL=new URL(getCodeBase().toString()+"www_transfers");
                } catch(MalformedURLException e) {
                    System.out.println(e.getMessage());
                    fileURL=null;
                }     
            } // param==null
        
            if(fileURL==null) {
                System.out.println("ERROR: could not find transfers log!");
                graphPanel.disable();
                return;
            }

            if(!application) {
                OptionTaking opter;
                Color tC;
                Font tF;
            
                opter=graphPanel.myCanvas;

                if(getParameter("interfaceFontName")!=null) {
                    ifName=getParameter("interfaceFontName");
                }
                if(getParameter("interfaceFontSize")!=null) {
                    ifSize=getIntParameter("interfaceFontSize");
                }
            
                display=getParameter("display");
                collapseItems=getParameter("collapseItems");
            
                if(getParameter("hideControlPanel")!=null) {
                    hideControlPanel=getBooleanParameter("hideControlPanel");
                }
                if(getParameter("hideStatusField")!=null) {
                    hideStatusField=getBooleanParameter("hideStatusField");
                }
            
                tC=getColorParameter("backGroundColor");
                if(tC!=null)
                    opter.setBackGroundColor(tC);
            
                tC=getColorParameter("graphColor");
                if(tC!=null)
                    opter.setGraphColor(tC);
            
                tC=getColorParameter("gridColor");
                if(tC!=null)
                    opter.setGridColor(tC);
            
                tC=getColorParameter("legendColor");
                if(tC!=null)
                    opter.setFontColor(tC);

                tF=getFontParameter("legendFontName", "legendFontSize", "legendFontBold", "legendFontItalic");
                if(tF!=null)
                    opter.setLegendFont(tF);
            
                if(getParameter("skipX")!=null)
                    opter.setXGridEveryOther((double)getIntParameter("skipX"));
                
                if(getParameter("skipY")!=null)
                    opter.setYGridEveryOther((double)getIntParameter("skipY"));
            
                if(getParameter("showGrid")!=null)
                    opter.setDoGrid(getBooleanParameter("showGrid"));
            
                if(getParameter("pieSlices")!=null)
                    opter.setMaximumPies(getIntParameter("pieSlices"));
            
                if(getParameter("filterFiles")!=null)
                    filterFiles=getBooleanParameter("filterFiles");

                if(getParameter("filterSites")!=null)
                    filterSites=getBooleanParameter("filterSites");
            
                if(getParameter("filters")!=null)
                    fFilterStrings=getParameter("filters");

                if(getParameter("fileFilters")!=null)
                    fFilterStrings=getParameter("fileFilters");
                    
                if(getParameter("siteFilters")!=null)
                    sFilterStrings=getParameter("siteFilters");
                
                if(getParameter("sortLog")!=null)
                    sortLog=getBooleanParameter("sortLog");
                
                if(getParameter("logFormat")!=null) {
                    param=getParameter("logFormat");

                    if(param.equalsIgnoreCase("combined"))
                        logFormat=WWWTransfer.LOG_COMBINED;
                    else if(param.equalsIgnoreCase("common"))
                        logFormat=WWWTransfer.LOG_COMMON;
                }
            
                if(getParameter("showAccesses")!=null) {
                    showAccesses=getBooleanParameter("showAccesses");
                }
                if(getParameter("showDomains")!=null) {
                    showDomains=getBooleanParameter("showDomains");
                }
                if(getParameter("showSites")!=null) {
                    showSites=getBooleanParameter("showSites");
                }
                if(getParameter("showRFC931")!=null) {
                    showRFC931=getBooleanParameter("showRFC931");
                }
                if(getParameter("showAuthUser")!=null) {
                    showAuthUser=getBooleanParameter("showAuthUser");
                }
                if(getParameter("showItems")!=null) {
                    showItems=getBooleanParameter("showItems");
                }
                if(getParameter("showUserAgents")!=null) {
                    showUserAgents=getBooleanParameter("showUserAgents");
                }
                if(getParameter("showKBytes")!=null) {
                    showKBytes=getBooleanParameter("showKBytes");
                }
                if(getParameter("showReferers")!=null) {
                    showReferers=getBooleanParameter("showReferers");
                }
                if(getParameter("showCodes")!=null) {
                    showCodes=getBooleanParameter("showCodes");
                }
            
                if(getParameter("categorizeUA")!=null) {
                    categorizeUA=getBooleanParameter("categorizeUA");
                }
            } // !application
    
        if(showAccesses)
            catChoice.addItem(WWWTransfer.accesses /* "Accesses" */);
        if(showDomains)
            catChoice.addItem(WWWTransfer.domains /* "Domains" */);
        if(showSites)
            catChoice.addItem(WWWTransfer.sites /* "Sites" */);
        if(showRFC931)
            catChoice.addItem(WWWTransfer.rfc931);
        if(showAuthUser)
            catChoice.addItem(WWWTransfer.authUser);
        if(showItems)
            catChoice.addItem(WWWTransfer.items /* "Items" */);
        if(showUserAgents)
            catChoice.addItem(WWWTransfer.clients /* "Clients" */);
        if(showKBytes)
            catChoice.addItem(WWWTransfer.kBytes /* "KBytes" */);
        if(showReferers)
            catChoice.addItem(WWWTransfer.referers /* "Referers" */);
        if(showCodes)
            catChoice.addItem(WWWTransfer.codes);
        
        if(hideControlPanel)
            remove(controlPanel);
        if(hideStatusField)
            remove(statusPanel);

        setInterfaceFont(ifName, ifSize);
        
        toker=new StringTokenizer(fFilterStrings, ", ");
        fFilters=new Vector();
        while (toker.hasMoreTokens()) {
                fFilters.addElement(toker.nextToken()); 
        }         
                
        toker=new StringTokenizer(sFilterStrings, ", ");
        sFilters=new Vector();
        while (toker.hasMoreTokens()) {
                sFilters.addElement(toker.nextToken()); 
        }         

        myParser=new WWWParser(fileURL, sortLog, collapseItems, logFormat, categorizeUA, this);
        if(!keepRunning) return;
        filterFrame=new Filters(graphPanel.myCanvas, myParser, fFilters, sFilters, filterFiles, filterSites);
        //myParser.setFilter(filterFrame.filterList);
        myParser.setFilterFrame(filterFrame);
        graphPanel.myCanvas.setStatusReciever(statusField);
        graphPanel.setParser(myParser);
     
        weeks=myParser.numberOfWeeks();
        for(loop=0;loop<weeks;loop++) {
            String name="Week "+Integer.toString(loop+1);
            showChoice.addItem(name);
        }

        if(display!=null) { 
            toker=new StringTokenizer(display);
            try {
                int d1, d2, d3;
            
                d1=Integer.parseInt(toker.nextToken());
                d2=Integer.parseInt(toker.nextToken());
                d3=Integer.parseInt(toker.nextToken());
                
                showChoice.select(d1);
                switch(d2) {
                    case 0:
                        CheckboxGrpIntypePanel.setCurrent(pieButton);
                        break;
                    case 1:
                        CheckboxGrpIntypePanel.setCurrent(barButton);
                        break;
                    case 2:
                        CheckboxGrpIntypePanel.setCurrent(lineButton);
                        break;
                    default:
                        break;
                }
                catChoice.select(d3);
                
                showChoice_Action(null);
                pieButton_Action(null);
                catChoice_Action(null);
            } catch(Exception e) {
                System.out.println("Error parsing display: "+e.getMessage());
            }
        } // display!=null
        
        //layout(); validate(); layout(); validate();

        if(keepRunning) {
            loadingLabel.hide();
            graphPanel.enable();
            controlPanel.enable();
        }
                
        if(keepRunning) {
            loaded=true;
        }
        //} // !loaded
    } // End of run()

    // stop()
    public void stop()
    {
        //keepRunning = false;
        System.out.println("WWW_Usage.stop: stopped on "+(new Date()).toString());
    } // End of stop()

    // destroy()
    public void destroy()
    {
        keepRunning = false;
        System.out.println("WWW_Usage.destroy: destroyed on "+(new Date()).toString());
    } // End of destroy()

    public void paint(Graphics g)
    {
        super.paint(g);
        graphPanel.repaint();
        controlPanel.repaint();
        // paint()
        // End of paint()
    }

    public void InitialPositionSet()
    {
 //       validate(); layout();
        // InitialPositionSet()
        /*
        resize(602,382);
        graphPanel.reshape(13,8+MenuBarHeight,414,238);
        loadingLabel.reshape(41,93,234,19);
        controlPanel.reshape(442,4+MenuBarHeight,84,236);
        
       typePanel.reshape(1,67,80,43);
       pieButton.reshape(0,0,40,14);
       lineButton.reshape(0,16,40,14);
       Label1.reshape(0,0,91,19);
       Label2.reshape(0,48,87,19);
       showChoice.reshape(1,127,80,24);
       Label3.reshape(0,108,51,19);
       infoButton.reshape(1,209,80,24);
       filterButton.reshape(1,182,80,24);
       optionButton.reshape(1,155,80,24);
       catChoice.reshape(1,19,80,24);
       
       barButton.reshape(1,30,39,17);
       
       statusPanel.reshape(17,257+MenuBarHeight,500,49);
       statusField.reshape(175,9,121,24);
       */
       // End of InitialPositionSet()    
    }

    public boolean handleEvent(Event evt)
    {
        // handleEvent()
        if (evt.id == Event.WINDOW_DESTROY && evt.target == this) WWW_Usage_WindowDestroy(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == infoButton) infoButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == showChoice) showChoice_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == pieButton) pieButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == lineButton) pieButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == filterButton) filterButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == optionButton) optionButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == catChoice) catChoice_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == barButton) pieButton_Action(evt.target);
        // End of handleEvent()

        return super.handleEvent(evt);
    }

    // Event Handling Routines
    public void WWW_Usage_WindowDestroy(Object target)
    {
        stop();
        System.exit(0);
    }

    public void infoButton_Action(Object target)
    {
        infoFrame.show();
        if(!infoShown) {
            infoFrame.InitialPositionSet();
            infoShown=true;
        }
    }

    public void showChoice_Action(Object target)
    {
        if(showChoice.getSelectedIndex() == 0) {
            graphPanel.myCanvas.setOptions(catChoice.getSelectedItem()+myParser.weekly);
        } else if(showChoice.getSelectedIndex() == 1) {
            graphPanel.myCanvas.setOptions(catChoice.getSelectedItem()+myParser.averageWeek);
        } else {
            graphPanel.myCanvas.setOptions(catChoice.getSelectedItem()+" "+showChoice.getSelectedItem()); 
        }
        repaint();
    }

    public void pieButton_Action(Object target)
    {
        graphPanel.myCanvas.setType(CheckboxGrpIntypePanel.getCurrent().getLabel());
    }

    public void filterButton_Action(Object target)
    {
        filterFrame.show();
        if(!filtersShown) {
            filterFrame.InitialPositionSet();
            filtersShown=true;
        }
    }

    public void optionButton_Action(Object target)
    {
        graphPanel.myCanvas.doOptioner();
    }

    public void catChoice_Action(Object target)
    {
        String label=catChoice.getSelectedItem();
        if(label.equals(WWWTransfer.accesses) || label.equals(WWWTransfer.kBytes)) {
        }
        else {
            CheckboxGrpIntypePanel.setCurrent(pieButton);
            pieButton_Action(null);
        }
        showChoice_Action(null);
    
    }

    // End of Event Handling Routines

    public static void main(String args[]) {
        ApplicationFrame f = new ApplicationFrame("WWW_Usage" + WWW_Usage.versionString);
        int loop;
        WWW_Usage wwwUsage = new WWW_Usage();
        wwwUsage.application=true;
        if(args.length>0)
            wwwUsage.arg1=args[0];
        else
            wwwUsage.arg1=null;
        for(loop=0;loop<args.length;loop++)
            System.out.println("arg"+loop+"["+args[loop]+"]");
        wwwUsage.init();
        wwwUsage.start();

        f.add("Center", wwwUsage);
        f.resize(536, 361);
        f.show();
    }
    
    public String getAppletInfo() {
        return "WWW Usage "+versionString+" Copyright (C) 1997  Bill Bereza.\nAll Rights Reserved.";
    }
    
    public String[][] getParameterInfo()
    {
/** parameters to read in
<param name="WWWURL" value="http://www.host.net/usage/www_transfers">
<param name="skipX" value="0">
<param name="skipY" value="4">
<param name="showGrid" value="true">
<param name="pieSlices" value="10">
<param name="legendFontName" value="Helvetica">
<param name="legendFontBold" value="true">
<param name="legendFontItalic" value="true">
<param name="legendFontSize" value="10">
<param name="backGroundColor" value="255 255 240">
<param name="graphColor" value="255 0 0">
<param name="gridColor" value="0 0 240">
<param name="legendColor" value="0 0 0">
<param name="filterFiles" value="true">
<param name="filterSites" value="true">
<param name="filters" value=".gif, .jpg, .jpeg, www_transfers, .class">
<param name="fileFilters" value=".gif, .au">
<param name="siteFilters" value=".gps-mi.concentric.net">
<param name="sortLog" value="false">
<param name="logFormat" value="combined">
<param name="showAccesses" value="true">
<param name="showDomains" value="true">
<param name="showSites" value="true">
<param name="showRFC931" value="false">
<param name="showAuthUser" value="false">
<param name="showItems" value="true">
<param name="showUserAgents" value="true">
<param name="showKBytes" value="true">
<param name="showReferers" value="true">
<param name="showCodes" value="true">
<param name="display" value="0 2 0">
<param name="hideControlPanel" value="false">
<param name="hideStatusField" value="false">
<param name="collapseItems" value="/~Bereza/ /~Bereza /~Bereza/index.html, /~Bereza/survey/ /~Bereza/survey /~Bereza/survey/index.shtml /~Bereza/survey/systems.shtml">
<param name="categorizeUA" value="false">
<param name="interfaceFontName" value="Dialog">
<param name="interfaceFontSize" value="10">
*/
    String pinfo[][]=
    {
        {"WWWURL", "String", "URL to get access log"},
        {"skipX", "int", "number of lines to skip in X direction for grid"},
        {"skipY", "int", "number of lines to skip in Y direction for grid"},
        {"showGrid", "boolean", "show the bloody grid"},
        {"pieSlices", "int", "number of pie slices to show for pie chart"},
        {"legendFontName", "String", "name of font to use for legends"},
        {"legendFontBold", "boolean", "to bold or not to bold"},
        {"legendFontItalic", "boolean", "slant or no slant"},
        {"legendFontSize", "int", "size of legend text"},
        {"backGroundColor", "int int int", "color of graph background"},
        {"graphColor", "int int int", "color of the line in lines graph"},
        {"legendColor", "int int int", "color of text for legends"},
        {"gridColor", "int int int", "color of grid lines for lines graph"},
        {"filterFiles", "boolean", "apply filtering to file names"},
        {"filterSites", "boolean", "apply filtering to site/domains"},
        {"fileFilters", "String, String, ...", "comma separated list of file filter strings"},
        {"siteFilters", "String, String, ...", "comma separated list of site filter strings"},
        {"sortLog", "boolean", "sort transfers log into chronological order"},
        {"logFormat", "String", "type of log file [combined|common]"},
        {"showAccesses" , "boolean", "show this type of graph"},
        {"showDomains" , "boolean", "show this type of graph"},
        {"showSites" , "boolean", "show this type of graph"},
        {"showRFC931" , "boolean", "show this type of graph"},
        {"showAuthUser" , "boolean", "show this type of graph"},
        {"showItems" , "boolean", "show this type of graph"},
        {"showUserAgents" , "boolean", "show this type of graph"},
        {"showKBytes" , "boolean", "show this type of graph"},
        {"showReferers" , "boolean", "show this type of graph"},
        {"showCodes" , "boolean", "show this type of graph"},
        {"display", "int int int", "set options on start"},
        {"hideControlPanel", "boolean", "hide Control Panel"},
        {"hideStatusField", "boolean", "hide Status Field"},
        {"collapseItems", "String String .. String, String String .. String, ...", "collapse items into one"},
        {"categorizeUA", "boolean", "categorize User Agents"},
        {"interfaceFontName", "String", "font to use for interface"},
        {"interfaceFontSize", "int", "size of font to use for interface"}
    };
    return pinfo;
    }
} // End of Class WWW_Usage


class GraphPanel extends Panel {
    protected WWWParser myParser;
    public GraphCanvas myCanvas;
    
    GraphPanel() {
        myCanvas=new GraphCanvas();
        myParser=null;
    }
    
    public void paint(Graphics g) { super.paint(g); validate(); layout(); validate(); layout(); }
    
    public void setParser(WWWParser parser) {
        
        myParser=parser;
        removeAll();
        setLayout(new BorderLayout());
        
        myCanvas.setParser(myParser);
        myCanvas.setOptions(WWWTransfer.accesses+myParser.weekly);
        myCanvas.setType(myCanvas.lineType);
        add("Center",myCanvas);
        
        // trying to work around a Netscape problem
        validate(); layout();
        validate(); layout();
        myCanvas.show();
        myCanvas.validate();
    }
}
