/* WWWTransfer.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    address:
           9526 Judson Rd.
           Ravenna, MI 49451
*/

import java.util.*;
import java.net.*;
import java.io.*;

class CompareTransferDates extends CompareItems {
    public int compareItems(Object a0, Object b0) {
        Date a,b;
        a=((WWWTransfer)a0).getDateAccessed();
        b=((WWWTransfer)b0).getDateAccessed();
        
        if(a.before(b))
            return 1;
        if(a.after(b))
            return -1;
        return 0; // a.equals(b)
    }
}

public class WWWTransfer extends Object {
    private String logTokens="\r\n";

    protected Hashtable countryCodeTable;

    /* These variables are the real contents of this class */
    protected String server;
    protected String clientHost;
    protected Date dateAccessed;
    protected String fileURL;
    protected String clientInfo;
    protected String refererInfo;
    protected int bytesRead;
    protected int serverResponse;
    protected String rfc931Info;
    protected String authUserInfo;
    /**/

    protected boolean categorizeUA;
    
    public static int LOG_COMMON=0;
    public static int LOG_COMBINED=1;
    
    public static String accesses="Accesses";
    public static String sites="Sites";
    public static String domains="Domains";
    public static String items="Items";
    public static String clients="UserAgents";
    public static String kBytes="KBytes";
    public static String referers="Referers";
    public static String codes="Codes";
    public static String rfc931="rfc931";
    public static String authUser="AuthUser";

    public Object getInfo(String wotFor) {
        String wt=wotFor.intern();
        Object ret=null;
        
        if(wt.equals(accesses))
            ret=getDateAccessed();
        else if(wt.equals(sites))
            ret=getClientHost();
        else if(wt.equals(domains))
            ret=getDomain();
        else if(wt.equals(items))
            ret=getFileURL();
        else if(wt.equals(clients))
            ret=getClientInfo();
        else if(wt.equals(kBytes))
            ret=new Integer(getBytesRead());
        else if(wt.equals(referers))
            ret=getRefererInfo();
        else if(wt.equals(codes))
            ret=getServerResponse();
        else if(wt.equals(rfc931))
            ret=getRFC931Info();
        else if(wt.equals(authUser))
            ret=getAuthUserInfo();

        return ret;
    }

    public String getStringInfo(String wotFor) { return getInfo(wotFor).toString(); }

    private String convMonth(String m) {
        if(m.equals("Jan")) return "00";
        if(m.equals("Feb")) return "01";
        if(m.equals("Mar")) return "02";
        if(m.equals("Apr")) return "03";
        if(m.equals("May")) return "04";
        if(m.equals("Jun")) return "05";
        if(m.equals("Jul")) return "06";
        if(m.equals("Aug")) return "07";
        if(m.equals("Sep")) return "08";
        if(m.equals("Oct")) return "09";
        if(m.equals("Nov")) return "10";
        if(m.equals("Dec")) return "11";
        return "";
    }
    
    private String getReasonPhrase(int code) {
        String classPhrase, specificPhrase;
        int classCode=code/100;
        
        switch(classCode) {
            case 1:
                classPhrase="Informational";
                break;
            case 2:
                classPhrase="Success";
                break;
            case 3:
                classPhrase="Redirection";
                break;
            case 4:
                classPhrase="Client Error";
                break;
            case 5:
                classPhrase="Server Error";
                break;
            default:
                classPhrase="Unknown";
                break;
        }
        
        switch(code) {
            //case 123: specificPhrase=" - Code Unavailable"; break;
            case 100: specificPhrase=" - Continue"; break;
            case 101: specificPhrase=" - Switching Protocols"; break;
            case 200: specificPhrase=" - OK"; break;
            case 201: specificPhrase=" - Created"; break;
            case 202: specificPhrase=" - Accepted"; break;
            case 203: specificPhrase=" - Non-Authoritative Information"; break;
            case 204: specificPhrase=" - No Content"; break;
            case 205: specificPhrase=" - Reset Content"; break;
            case 206: specificPhrase=" - Partial Content"; break;
            case 300: specificPhrase=" - Multiple Choices"; break;
            case 301: specificPhrase=" - Moved Permanently"; break;
            case 302: specificPhrase=" - Moved Temporarily"; break;
            case 303: specificPhrase=" - See Other"; break;
            case 304: specificPhrase=" - Not Modified"; break;
            case 305: specificPhrase=" - Use Proxy"; break;
            case 400: specificPhrase=" - Bad Request"; break;
            case 401: specificPhrase=" - Unauthorized"; break;
            case 402: specificPhrase=" - Payment Required"; break;
            case 403: specificPhrase=" - Forbidden"; break;
            case 404: specificPhrase=" - Not Found"; break;
            case 405: specificPhrase=" - Method Not Allowed"; break;
            case 406: specificPhrase=" - Not Acceptable"; break;
            case 407: specificPhrase=" - Proxy Authentication Required"; break;
            case 408: specificPhrase=" - Request Time-out"; break;
            case 409: specificPhrase=" - Conflict"; break;
            case 410: specificPhrase=" - Gone"; break;
            case 411: specificPhrase=" - Length Required"; break;
            case 412: specificPhrase=" - Precondition Failed"; break;
            case 413: specificPhrase=" - Request Entity Too Large"; break;
            case 414: specificPhrase=" - Request-URI Too Large"; break;
            case 415: specificPhrase=" - Unsupported Media Type"; break;
            case 500: specificPhrase=" - Internal Server Error"; break;
            case 501: specificPhrase=" - Not Implemented"; break;
            case 502: specificPhrase=" - Bad Gateway"; break;
            case 503: specificPhrase=" - Service Unavailable"; break;
            case 504: specificPhrase=" - Gateway Time-out"; break;
            case 505: specificPhrase=" - HTTP Version not supported"; break;
            default:
                specificPhrase="";
                break;
        }
        return classPhrase.intern()+specificPhrase.intern();
    }
    
    public void setCountryCodeTable(Hashtable to) { countryCodeTable=to; }
    
    WWWTransfer(String server, String logLine, int logFormat, Hashtable collapsers) {
        StringTokenizer logTokenizer, tempTokenizer;
        String tempToker, tempDate, temp, y, m, d, t, hr, min, sec, zone;
        
        categorizeUA=false;
        setServer(server);
        logTokenizer=new StringTokenizer(logLine,logTokens);

        try {
            String host;
            int ind;
            
            temp=logTokenizer.nextToken(" ");
            ind=temp.indexOf('.');
            if(ind<0) {
                host="xxx."+temp;
            }
            else {
                host="xxx"+temp.substring(ind);
            }
            setClientHost(host);
        } catch(NoSuchElementException e) {
            System.out.println("Error parsing www_transfer: "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            setClientHost("Unknown/Error");
        }
        
        try {
            temp=logTokenizer.nextToken(" []:/");
            if(temp.equals("-"))
                temp="";
            setRFC931Info(temp);
        } catch(NoSuchElementException e) {
            System.out.println("Error parsing www_transfer: "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            setRFC931Info("Unknown/Error");
        }
        
        try {
            temp=logTokenizer.nextToken();
            if(temp.equals("-"))
                temp="";
            setAuthUserInfo(temp);
        } catch(NoSuchElementException e) {
            System.out.println("Error parsing www_transfer: "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            setAuthUserInfo("Unknown/Error");
        }
        
        tempDate=y=m=d=null;

        try {
            d=logTokenizer.nextToken();  
            m=logTokenizer.nextToken();
            y=logTokenizer.nextToken();
            
            hr=logTokenizer.nextToken(); 
            min=logTokenizer.nextToken(); 
            sec=logTokenizer.nextToken();
            
            zone=logTokenizer.nextToken();
            
            //System.out.println(d+"/"+m+"/"+y);
        } catch(NoSuchElementException e) {
            System.out.println("Error parsing date: "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            y="1974"; m="07"; d="29"; hr="00"; min="00"; sec="00"; zone="";
        }
        /* Date string is converted to the format of:
            "Sat, 12 Aug 1995 13:30:00 GMT+0430"
         */
        tempDate=d+" "+m+" "+y+" "+hr+":"+min+":"+sec; //+" GMT"+zone;
        //System.out.println(tempDate);
        try {
            // damn you JDK1.0.2, damn you straight to hell!
            // I'd really rather use 1.1
            //m=convMonth(m);
            //setDateAccessed(new Date(Integer.parseInt(y)-1900,Integer.parseInt(m),Integer.parseInt(d)));
            setDateAccessed(new Date(tempDate));
            //System.out.println(getDateAccessed().toString());
        } catch(Exception e) {
            System.out.println("Error doing date: "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            setDateAccessed(new Date());
        }
        temp=null;
        try {
            temp="xxx";
            logTokenizer.nextToken("]\" ");
            temp=logTokenizer.nextToken("\"");
            tempToker=temp;
            tempTokenizer=new StringTokenizer(tempToker, " ");
            temp=tempTokenizer.nextToken();
            int insanity_check=0;
            while(collapsers.get(temp)!=null) {
                insanity_check++;
                temp=(String)collapsers.get(temp);
                if(insanity_check>32767) {
                    System.out.println("WWWTransfer:insanity check:\n\tI think there may be a problem with how you defined your collapseItems parameter");
                }
            }
            setFileURL(temp);
        } catch(NoSuchElementException e) {
            System.out.println("Error parsing fileURL:"+temp+": "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            setFileURL("Unknown/Error");
        }
        
        try {
            temp="xxx";
            //logTokenizer.nextToken(" \"");
            logTokenizer.nextToken(" ");
            temp=logTokenizer.nextToken();
            if(temp.equals("-")) {
                setServerResponse("0");
            }
            else {
                setServerResponse(temp);
            }
        } catch(Exception e) {
            System.out.println("Error parsing serverResponse:"+temp+": "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            setServerResponse("0");
        }

        try {
            temp="xxx";
            temp=logTokenizer.nextToken();
            if(temp.equals("-")) {
                setBytesRead(0);
            }
            else {
                setBytesRead(Integer.parseInt(temp));
            }
        } catch(Exception e) {
            System.out.println("Error parsing bytesRead:"+temp+": "+e.getMessage());
            System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
            setBytesRead(0);
        }
        
        if(logFormat!=LOG_COMBINED) {
            setRefererInfo("");
            setClientInfo("");
        }
        else {
            try {
                temp="xxx";
                temp=logTokenizer.nextToken(" ");
                setRefererInfo(temp.substring(1,temp.length()-1));
            } catch(Exception e) {
                System.out.println("Error parsing refererInfo:"+temp+": "+e.getMessage());
                System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
                setRefererInfo("Unkown/Error");
            }
        
            try {
                temp="xxx";
                temp=logTokenizer.nextToken("\r\n");
                setClientInfo(temp.substring(2,temp.length()-1));
            } catch(Exception e) {
                System.out.println("Error parsing clientInfo:"+temp+": "+e.getMessage());
                System.out.println("server: "+server+" line: "+logLine+"\ntokens: "+logTokenizer.countTokens());
                setClientInfo("Unknown/Error");
            }
        }
    }
    
    public void setServer(String to) { server=to.intern(); }
    public String getServer() { return server.intern(); }
    
    public void setClientHost(String to) { clientHost=to.intern(); }
    public String getClientHost() { return clientHost.intern(); }
    
    public void setRFC931Info(Object to) { rfc931Info=((String)to).intern(); } 
    public Object getRFC931Info() { return rfc931Info.intern(); }
    
    public void setAuthUserInfo(String to) { authUserInfo=to.intern(); }
    public String getAuthUserInfo() { return authUserInfo.intern(); }

    public String getDomain() { 
        String ret,z, name;
        try {
            z=clientHost.substring(clientHost.lastIndexOf('.')+1);
        } catch(StringIndexOutOfBoundsException e) {
            System.out.println(e.getMessage());
            return "ERR";
        }
        ret="???";
        try {
            Integer.valueOf(z);
        } catch(NumberFormatException e) {
            ret=z.toLowerCase();
        }
        name=(String)(countryCodeTable.get(ret.intern()));
        if(name==null) {
            name=ret.intern();
        }
        return name.intern();
    }

    public void setCategorizeUA(boolean to) { categorizeUA=to; }
    public boolean getCategorizeUA() { return categorizeUA; }
    
    public void setDateAccessed(Date to) { dateAccessed=to; }
    public Date getDateAccessed() { return dateAccessed; }
    
    public void setFileURL(String to) { fileURL=to.intern(); }
    public String getFileURL() { return fileURL.intern(); }
    
    public void setClientInfo(Object to) { clientInfo=((String)to).intern(); }
    public Object getClientInfo() { 
        if(!getCategorizeUA()) {    
            return clientInfo.intern(); 
        }
        String ua=clientInfo.intern();
        boolean proxy, robot;
        proxy=ua.indexOf("via")>=0 || ua.indexOf("roxy")>=0 || ua.indexOf("cache")>=0;
        
        if(proxy) {
            return "Proxy".intern();
        }
        robot=ua.indexOf("bot")>=0 || ua.indexOf("pider")>=0;
        if(robot) { 
            return "Robot".intern();
        }
        return "Client".intern();
    }    

    public void setRefererInfo(Object to) { refererInfo=((String)to).intern(); }
    public Object getRefererInfo() { return refererInfo.intern(); }

    public void setServerResponse(String to) { 
        try {
            serverResponse=Integer.parseInt(to); 
        } catch(Exception e) {
            serverResponse=200;
            System.out.println("Error parsing serverResponse:"+to+":"+e.getMessage());
        }
    }
    public String getServerResponse() { return getReasonPhrase(serverResponse).intern(); }

    public void setBytesRead(int to) { bytesRead=to; }
    public int getBytesRead() { return bytesRead; }

    public URL getURL() {
        try {
            return new URL("http://"+getServer()+getFileURL()); 
        } catch(MalformedURLException e) {
            System.out.println("URL exception "+e.getMessage());
        }
        return null;
    }
    
    public String toString() {
        String ret=getClientHost()+" \t" /* I shouldn't include this, should I? * +(String)getRFC931Info()+"\t"+getAuthUserInfo() */ +" \t"+ getDateAccessed().toLocaleString()+" \t"+getFileURL()+" \t"+getServerResponse()+" \t"+Integer.toString(getBytesRead())+" bytes \t"+"\""+(String)getClientInfo()+"\" \t"+"\""+(String)getRefererInfo()+"\"";
        return ret.intern();
    }
}
