// {$R OptionsFrame.JFM}


/* OptionsFrame.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    address:
           9526 Judson Rd.
           Ravenna, MI 49451
*/

import LabelPanel;
import OptionTaking;

import java.awt.*;

/*
class OptionPanel extends Panel {
    Dimension dim=new Dimension(100,200);
    public Dimension minimumSize() {
        return dim;
    }
    
    public Dimension preferredSize() { 
        return minimumSize();
        //return new Dimension(116,324); 
    }
}
*/

// Class OptionsFrame
public class OptionsFrame extends Frame
{
    final int MenuBarHeight = 0;
    boolean fForm_Create;

    // Component Declaration
    public Panel sliderPanel;
    public Panel lineGraphPanel;
    public TextField xGridField;
    public TextField yGridField;
    public Checkbox doGridBox;
    public Label skipXLabel;
    public Label skipYLabel;
    public Panel colorsPanel;
    public TextField redField;
    public TextField greenField;
    public TextField blueField;
    public Choice colorChoice;
    public Panel pieGraphPanel;
    public TextField maxPiesField;
    public Label pieSliceLabel;
    public Panel fontPanel;
    public List fontList;
    public Checkbox boldBox;
    public Checkbox italicBox;
    public TextField sizeField;
    public Panel mainPanel;
    public Panel displayPanel;
    public Panel chooserPanel;
    public Choice optionsChoice;
    public Panel nullOptPanel;
    public Label Label4;
    public Panel userAgentsPanel;
    public Checkbox catCheckBox;
    public Panel eastFontPanel;
    public Panel southColorsPanel;
    public Panel westLineGraphPanel;
    public Panel interfaceFontPanel;
    public List iFontList;
    public TextField iSizeField;
    // End of Component Declaration

    protected OptionTaking myOptee;

    // Constructor
    public OptionsFrame(OptionTaking ot)
    {
        myOptee=ot;
    
        // Frame Initialization
        setForeground(Color.black);
        setBackground(Color.lightGray);
        setFont(new Font("Dialog",Font.BOLD,12));
        setTitle("Options");
        setLayout(new BorderLayout());
        // End of Frame Initialization

        setIconImage(GlobalVillage.iconImage);

        // Component Initialization
        sliderPanel = new Panel();
        sliderPanel.setLayout(null);
        sliderPanel.setForeground(Color.black);
        sliderPanel.setBackground(Color.lightGray);
        sliderPanel.setFont(new Font("Dialog",Font.BOLD,12));
        lineGraphPanel = new Panel();
        lineGraphPanel.setLayout(new BorderLayout());
        lineGraphPanel.setForeground(Color.black);
        lineGraphPanel.setBackground(Color.lightGray);
        lineGraphPanel.setFont(new Font("Dialog",Font.BOLD,12));
        xGridField = new TextField("xGridField");
        xGridField.setForeground(Color.black);
        xGridField.setBackground(Color.white);
        xGridField.setFont(new Font("Dialog",Font.PLAIN,10));
        yGridField = new TextField("yGridField");
        yGridField.setForeground(Color.black);
        yGridField.setBackground(Color.white);
        yGridField.setFont(new Font("Dialog",Font.PLAIN,10));
        doGridBox = new Checkbox("Show");
        doGridBox.setBackground(Color.lightGray);
        doGridBox.setFont(new Font("Dialog",Font.PLAIN,10));
        skipXLabel = new Label("skip X",Label.RIGHT);
        skipXLabel.setFont(new Font("Dialog",Font.PLAIN,10));
        skipYLabel = new Label("skip Y",Label.RIGHT);
        skipYLabel.setFont(new Font("Dialog",Font.PLAIN,10));
        colorsPanel = new Panel();
        colorsPanel.setLayout(new BorderLayout());
        colorsPanel.setForeground(Color.black);
        colorsPanel.setBackground(Color.lightGray);
        colorsPanel.setFont(new Font("Dialog",Font.BOLD,12));
        redField = new TextField("redField");
        redField.setForeground(Color.black);
        redField.setBackground(Color.white);
        redField.setFont(new Font("Dialog",Font.PLAIN,10));
        greenField = new TextField("greenField");
        greenField.setForeground(Color.black);
        greenField.setBackground(Color.white);
        greenField.setFont(new Font("Dialog",Font.PLAIN,10));
        blueField = new TextField("blueField");
        blueField.setForeground(Color.black);
        blueField.setBackground(Color.white);
        blueField.setFont(new Font("Dialog",Font.PLAIN,10));
        colorChoice = new Choice();
        colorChoice.addItem("Background");
        colorChoice.addItem("Graph Line");
        colorChoice.addItem("Grid Lines");
        colorChoice.addItem("Legend Text");
        colorChoice.setFont(new Font("Dialog",Font.PLAIN,10));
        pieGraphPanel = new Panel();
        pieGraphPanel.setLayout(new BorderLayout());
        pieGraphPanel.setForeground(Color.black);
        pieGraphPanel.setBackground(Color.lightGray);
        pieGraphPanel.setFont(new Font("Dialog",Font.BOLD,12));
        maxPiesField = new TextField("maxPiesField");
        maxPiesField.setForeground(Color.black);
        maxPiesField.setBackground(Color.white);
        maxPiesField.setFont(new Font("Dialog",Font.PLAIN,10));
        pieSliceLabel = new Label("Pie Slices",Label.RIGHT);
        pieSliceLabel.setFont(new Font("Dialog",Font.PLAIN,10));
        fontPanel = new Panel();
        fontPanel.setLayout(new BorderLayout());
        fontPanel.setForeground(Color.black);
        fontPanel.setBackground(Color.lightGray);
        fontPanel.setFont(new Font("Dialog",Font.BOLD,12));
        fontList = new List();
        fontList.setForeground(Color.black);
        fontList.setBackground(Color.white);
        fontList.setFont(new Font("Dialog",Font.PLAIN,10));
        boldBox = new Checkbox("Bold");
        boldBox.setBackground(Color.lightGray);
        boldBox.setFont(new Font("Dialog",Font.PLAIN,10));
        italicBox = new Checkbox("Italic");
        italicBox.setBackground(Color.lightGray);
        italicBox.setFont(new Font("Dialog",Font.PLAIN,10));
        sizeField = new TextField("sizeField");
        sizeField.setForeground(Color.black);
        sizeField.setBackground(Color.white);
        sizeField.setFont(new Font("Dialog",Font.PLAIN,10));
        sliderPanel.show(false);
        mainPanel = new Panel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setForeground(Color.black);
        mainPanel.setBackground(Color.lightGray);
        mainPanel.setFont(new Font("Dialog",Font.BOLD,12));
        displayPanel = new Panel();
        displayPanel.setLayout(new CardLayout());
        displayPanel.setForeground(Color.black);
        displayPanel.setBackground(Color.lightGray);
        displayPanel.setFont(new Font("Dialog",Font.BOLD,12));
        chooserPanel = new Panel();
        chooserPanel.setLayout(new BorderLayout());
        chooserPanel.setForeground(Color.black);
        chooserPanel.setBackground(Color.lightGray);
        chooserPanel.setFont(new Font("Dialog",Font.BOLD,12));
        optionsChoice = new Choice();
        optionsChoice.addItem("Line Graph");
        optionsChoice.addItem("Pie Graph");
        optionsChoice.addItem("Legend Font");
        optionsChoice.addItem("Colors");
        optionsChoice.addItem("Interface Font");
        optionsChoice.setFont(new Font("Dialog",Font.PLAIN,10));
        nullOptPanel = new Panel();
        nullOptPanel.setLayout(new BorderLayout());
        nullOptPanel.setForeground(Color.black);
        nullOptPanel.setBackground(Color.lightGray);
        nullOptPanel.setFont(new Font("Dialog",Font.BOLD,12));
        Label4 = new Label("No Options",Label.CENTER);
        Label4.setFont(new Font("Dialog",Font.BOLD,12));
        userAgentsPanel = new Panel();
        userAgentsPanel.setLayout(new BorderLayout());
        userAgentsPanel.setForeground(Color.black);
        userAgentsPanel.setBackground(Color.lightGray);
        userAgentsPanel.setFont(new Font("Dialog",Font.BOLD,12));
        catCheckBox = new Checkbox("Categorize Agents");
        catCheckBox.setBackground(Color.lightGray);
        catCheckBox.setFont(new Font("Dialog",Font.PLAIN,10));
        eastFontPanel = new Panel();
        eastFontPanel.setLayout(new GridLayout(3,1,2,2));
        eastFontPanel.setForeground(Color.black);
        eastFontPanel.setBackground(Color.lightGray);
        eastFontPanel.setFont(new Font("Dialog",Font.BOLD,12));
        southColorsPanel = new Panel();
        southColorsPanel.setLayout(new GridLayout(1,3,2,2));
        southColorsPanel.setForeground(Color.black);
        southColorsPanel.setBackground(Color.lightGray);
        southColorsPanel.setFont(new Font("Dialog",Font.BOLD,12));
        westLineGraphPanel = new Panel();
        westLineGraphPanel.setLayout(new GridLayout(2,2,2,2));
        westLineGraphPanel.setForeground(Color.black);
        westLineGraphPanel.setBackground(Color.lightGray);
        westLineGraphPanel.setFont(new Font("Dialog",Font.BOLD,12));
        interfaceFontPanel = new Panel();
        interfaceFontPanel.setLayout(new BorderLayout());
        interfaceFontPanel.setForeground(Color.black);
        interfaceFontPanel.setBackground(Color.lightGray);
        interfaceFontPanel.setFont(new Font("Dialog",Font.BOLD,12));
        iFontList = new List();
        iFontList.setForeground(Color.black);
        iFontList.setBackground(Color.white);
        iFontList.setFont(new Font("Dialog",Font.PLAIN,10));
        iSizeField = new TextField("iSizeField");
        iSizeField.setForeground(Color.black);
        iSizeField.setBackground(Color.white);
        iSizeField.setFont(new Font("Dialog",Font.PLAIN,10));
        // End of Component Initialization

        // Add()s
        interfaceFontPanel.add("South", iSizeField);
        interfaceFontPanel.add("Center", iFontList);
        sliderPanel.add(interfaceFontPanel);
        lineGraphPanel.add("West", westLineGraphPanel);
        colorsPanel.add("South", southColorsPanel);
        fontPanel.add("East", eastFontPanel);
        userAgentsPanel.add("Center", catCheckBox);
        sliderPanel.add(userAgentsPanel);
        nullOptPanel.add("Center", Label4);
        sliderPanel.add(nullOptPanel);
        chooserPanel.add("Center", optionsChoice);
        mainPanel.add("North", chooserPanel);
        mainPanel.add("Center", displayPanel);
        add("Center", mainPanel);
        eastFontPanel.add(boldBox);
        eastFontPanel.add(italicBox);
        eastFontPanel.add(sizeField);
        fontPanel.add("Center",fontList);
        sliderPanel.add(fontPanel);
        pieGraphPanel.add("West", pieSliceLabel);
        pieGraphPanel.add("East", maxPiesField);
        sliderPanel.add(pieGraphPanel);
        colorsPanel.add("Center", colorChoice);
        southColorsPanel.add(redField);
        southColorsPanel.add(greenField);
        southColorsPanel.add(blueField);
        sliderPanel.add(colorsPanel);
        westLineGraphPanel.add(skipXLabel);
        westLineGraphPanel.add(xGridField);
        lineGraphPanel.add("East", doGridBox);
        westLineGraphPanel.add(skipYLabel);
        westLineGraphPanel.add(yGridField);
        sliderPanel.add(lineGraphPanel);
        add("South", sliderPanel);
        // End of Add()s


        displayPanel.add("Line Graph", lineGraphPanel);
        displayPanel.add("Pie Graph", pieGraphPanel);
        displayPanel.add("Legend Font", fontPanel);
        displayPanel.add("Colors", colorsPanel);
        displayPanel.add("Domains", nullOptPanel);
        displayPanel.add("Accesses", nullOptPanel);
        displayPanel.add("Sites", nullOptPanel);
        displayPanel.add("RFC931", nullOptPanel);
        displayPanel.add("AuthUser", nullOptPanel);
        displayPanel.add("Items", nullOptPanel);
        displayPanel.add("KBytes", nullOptPanel);
        displayPanel.add("Referers", nullOptPanel);
        displayPanel.add("UserAgents", userAgentsPanel);
        displayPanel.add("Interface Font", interfaceFontPanel);

        ((CardLayout)displayPanel.getLayout()).show(displayPanel,"Line Graph");

        validate(); layout();
        validate(); layout();
        fForm_Create = true;
    }

    public void InitialPositionSet()
    {   
        Font t;
        String fList[];
        int loop, sel;
             
        // InitialPositionSet()
        reshape(81,125,225,178); /*
        sliderPanel.reshape(88,176+MenuBarHeight,530,330);
        lineGraphPanel.reshape(28,-1,200,100);
        xGridField.reshape(55,17,30,24);
        yGridField.reshape(55,50,30,24);
        doGridBox.reshape(119,38,57,17);
        skipXLabel.reshape(5,20,48,19);
        skipYLabel.reshape(6,54,47,19);
        colorsPanel.reshape(25,101,200,100);
        redField.reshape(12,51,44,24);
        greenField.reshape(70,51,44,24);
        blueField.reshape(127,51,44,24);
        colorChoice.reshape(12,20,159,24);
        pieGraphPanel.reshape(22,202,200,100);
        maxPiesField.reshape(81,46,81,24);
        pieSliceLabel.reshape(9,49,66,19);
        fontPanel.reshape(277,210,200,100);
        fontList.reshape(6,19,108,62);
        boldBox.reshape(122,17,52,17);
        italicBox.reshape(122,35,54,17);
        sizeField.reshape(119,57,59,24);
        mainPanel.reshape(5,22+MenuBarHeight,211,143);
        displayPanel.reshape(0,25,200,100);
        chooserPanel.reshape(0,0,152,24);
        optionsChoice.reshape(0,0,132,24);
        nullOptPanel.reshape(340,25,200,100);
        Label4.reshape(30,34,104,19);
        userAgentsPanel.reshape(350,18,200,100);
        catCheckBox.reshape(29,24,147,17);
        eastFontPanel.reshape(113,85,185,41);
        southColorsPanel.reshape(5,83,185,41);
        westLineGraphPanel.reshape(7,79,185,41);
        interfaceFontPanel.reshape(250,81,185,87);
        iFontList.reshape(7,2,155,54);
        iSizeField.reshape(27,59,121,21);
        // End of InitialPositionSet()
*/
        xGridField.setText(Integer.toString((int)(myOptee.getXGridEveryOther())));
        yGridField.setText(Integer.toString((int)(myOptee.getYGridEveryOther())));
        doGridBox.setState(myOptee.getDoGrid());
        redField.setText(Integer.toString(myOptee.getBackGroundColor().getRed()));
        greenField.setText(Integer.toString(myOptee.getBackGroundColor().getGreen()));
        blueField.setText(Integer.toString(myOptee.getBackGroundColor().getBlue()));
        maxPiesField.setText(Integer.toString(myOptee.getMaximumPies()));

        fList=getToolkit().getFontList();

/** legend font */
        t=myOptee.getLegendFont();
        sel=fList.length-1;
        for(loop=0;loop<fList.length;loop++) {
            if(fList[loop].equals(t.getName())) {
                sel=loop;
            }
            fontList.addItem(fList[loop]);
        }
        fontList.select(sel);

/** interface font */
        sel=fList.length-1;
        for(loop=0;loop<fList.length;loop++) {
            if(fList[loop].equals(GlobalVillage.wwwUsage.getInterfaceFontName())) {
                sel=loop;
            }
            iFontList.addItem(fList[loop]);
        }
        iFontList.select(sel);

/** legend font */
        if(t.isBold())
            boldBox.setState(true);
        else
            boldBox.setState(false);
        
        if(t.isItalic())
            italicBox.setState(true);
        else
            italicBox.setState(false);
        
        sizeField.setText(Integer.toString(t.getSize()));
        iSizeField.setText(Integer.toString(GlobalVillage.wwwUsage.getInterfaceFontSize()));
            
        layout(); validate();
            
        fForm_Create = false;

    }

    public boolean handleEvent(Event evt)
    {
        // handleEvent()
        if (evt.id == Event.WINDOW_DESTROY && evt.target == this) OptionsFrame_WindowDestroy(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == xGridField) xGridField_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == doGridBox) doGridBox_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == yGridField) yGridField_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == colorChoice) colorChoice_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == redField) redField_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == greenField) redField_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == blueField) redField_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == maxPiesField) maxPiesField_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == fontList) fontList_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == boldBox) fontList_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == italicBox) fontList_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == sizeField) fontList_Action(evt.target);
        else if (evt.id == Event.LIST_SELECT && evt.target == fontList) fontList_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == optionsChoice) optionsChoice_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == iFontList) iFontList_Action(evt.target);
        else if (evt.id == Event.LIST_SELECT && evt.target == iFontList) iFontList_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == iSizeField) iFontList_Action(evt.target);
        // End of handleEvent()

        return super.handleEvent(evt);
    }

    public void paint(Graphics g)
    {
        // paint()
        // End of paint()
        if (fForm_Create) InitialPositionSet();
    }

    // Event Handling Routines
    public void OptionsFrame_WindowDestroy(Object target)
    {
        hide();
    }

    public void xGridField_Action(Object target)
    {
        try {
            myOptee.setXGridEveryOther(Integer.parseInt(((TextField)target).getText()));
        } catch(Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void yGridField_Action(Object target)
    {
        try {
            myOptee.setYGridEveryOther(Integer.parseInt(((TextField)target).getText()));
        } catch(Exception e) {
            System.out.println(e.getMessage());
        }    
    }

    public void doGridBox_Action(Object target)
    {
        boolean t=((Checkbox)target).getState();
        
        myOptee.setDoGrid(t);
        if(t) {
            yGridField.enable();
            xGridField.enable();
        }
        else {
            xGridField.disable();
            yGridField.disable();
        }
    }
    
    public void redField_Action(Object target)
    {
        int r=0,g=0,b=0;
        Color newColor;
        
        try {
            r=Integer.parseInt(redField.getText());
            g=Integer.parseInt(greenField.getText());
            b=Integer.parseInt(blueField.getText());
        } catch(Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        newColor=new Color(r,g,b);
        
        switch(colorChoice.getSelectedIndex()) {
            case 0:
                myOptee.setBackGroundColor(newColor);
                break;
            case 1:
                myOptee.setGraphColor(newColor);
                break;
            case 2:
                myOptee.setGridColor(newColor);
                break;
            case 3:
                myOptee.setFontColor(newColor);
                break;
            default:
                System.out.println("colorChoice error. Selected: "+((Choice)target).getSelectedItem());
                return;
        }
    }

    public void colorChoice_Action(Object target)
    {
        int sel=((Choice)target).getSelectedIndex();
        Color t;
        
        switch(sel) {
            case 0:
                t=myOptee.getBackGroundColor();
                break;
            case 1:
                t=myOptee.getGraphColor();
                break;
            case 2:
                t=myOptee.getGridColor();
                break;
            case 3:
                t=myOptee.getFontColor();
                break;
            default:
                System.out.println("colorChoice error. Selected: "+((Choice)target).getSelectedItem());
                return;
        }
        redField.setText(Integer.toString(t.getRed()));
        greenField.setText(Integer.toString(t.getGreen()));
        blueField.setText(Integer.toString(t.getBlue()));
    }

    public void maxPiesField_Action(Object target)
    {
        int p=10;
        
        try {
            p=Integer.parseInt(((TextField)target).getText());
        } catch(Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        myOptee.setMaximumPies(p);
    }

    public void fontList_Action(Object target)
    {
        int style, size;
        String name;
        
        name=fontList.getSelectedItem();
        if(name==null) {
            System.err.println("error: no font selected");
            
            return;
        }
        try {
            size=Integer.parseInt(sizeField.getText());
        } catch(Exception e) {
            System.err.println("error parsing size "+e.getMessage());
            return;
        }
        style=Font.PLAIN;
        if(boldBox.getState())
            style+=Font.BOLD;
        if(italicBox.getState())
            style+=Font.ITALIC;
        
        myOptee.setLegendFont(new Font(name,style,size));
    }

    public void optionsChoice_Action(Object target)
    {
        String sel=((Choice)target).getSelectedItem();
        ((CardLayout)displayPanel.getLayout()).show(displayPanel,sel);
    }

    public void iFontList_Action(Object target)
    {
        int size;
        String name;
        
        name=iFontList.getSelectedItem();
        if(name==null) {
            System.err.println("error: no font selected");
            
            return;
        }
        try {
            size=Integer.parseInt(iSizeField.getText());
        } catch(Exception e) {
            System.err.println("error parsing size "+e.getMessage());
            return;
        }
        GlobalVillage.wwwUsage.setInterfaceFont(name, size);
    }

    // End of Event Handling Routines

} // End of Class OptionsFrame

