
/* LabelPanel.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    address:
           9526 Judson Rd.
           Ravenna, MI 49451
*/
import java.awt.*;

class SlidingPanel extends Panel
{  
    protected Component current, last;
    protected int startDragX, startDragY;
    
    SlidingPanel() {
        current=null;
        last=null;
    }
 
    public Component add(Component item) {
        last=current;
        current=item;
        if(last!=null)
            last.disable();
        current.enable();
        super.add(item);
        return item;
    }
    
    public boolean mouseDown(Event evt, int x, int y) {
        Component t;
        
        t=locate(x,y);
        //System.out.println(t);
        if(t==null || t.equals(this) || t.equals(current)) {
            return false;
        }
        remove(t);
        add(t,0);
        last=current;
        last.disable();
        current=t;
        current.enable();
        startDragX=x;
        startDragY=y;
        return true;
    }
    /*
    public boolean mouseDrag(Event evt, int x, int y) {
        Component t;
        Rectangle r;
        
        t=locate(x,y);
        if(t==null || t.equals(this) || t.equals(current))
            return false;
        
        r=t.bounds();        
        t.move(x, y);
        return true;
    }
    */
}

public class LabelPanel extends Panel
{
    protected String title;
    protected Font titleFont=null;
    protected int tWidth, tHeight, tY;
    protected Color selectColor;
    protected Color unselectColor;
    protected Color frameColor;
    public boolean isSelected;
    
    LabelPanel(String t) {
        setTitle(t);
        title=t;
        selectColor=Color.white;
        unselectColor=Color.black;
        frameColor=Color.black;
        isSelected=false;
    }

    public void enable() {
        isSelected=true; repaint();
        super.enable();
    }
    
    public void disable() {
        isSelected=false; repaint();
        super.disable();
    }
/*
    public boolean inside(int x, int y) {
        Rectangle r=bounds();
        
        if(x>r.x && y>r.y && x<(r.x+tWidth) && y<(r.y+tHeight))
            return true;
        else
            return false;
    }
*/    
    public boolean mouseEnter(Event evt, int x, int y) {
        isSelected=true; repaint();
        return true;
    }
    
    public boolean mouseExit(Event evt, int x, int y) {
        isSelected=false; repaint();
        return true;
    }

    public void setTitle(String to) {
        FontMetrics tMet;
        if(titleFont==null)
           titleFont=new Font("Times",Font.ITALIC+Font.BOLD,10);

        tMet=getFontMetrics(titleFont);
        title=to;
        tHeight=tMet.getLeading()+tMet.getMaxAscent()+tMet.getMaxDescent();
        tY=tMet.getMaxAscent()+tMet.getLeading();
        tWidth=tMet.stringWidth(title)+4;
    }
    
    public String getTitle() { return title; }
    
    protected void drawFrame(Graphics g) {
        Rectangle r=bounds();
        g.setColor(frameColor);
        g.drawRect(0,tHeight,r.width-1,r.height-1-tHeight);
    }
    
    protected void drawTitleBar(Graphics g) {
        Rectangle r=bounds();
        g.setFont(titleFont);
        g.setColor(getBackground());
        g.fillRect(0,0,tWidth,tHeight);
        g.setColor(frameColor);
        if(isSelected) {
            g.fillRect(0,0,tWidth,tHeight);
            g.setColor(selectColor);
        }
        else {
            g.drawRect(0,0,tWidth,tHeight);
            g.setColor(unselectColor);
        }
        
        g.drawString(title,2,tY);
    }
    
    public void paint(Graphics g) {        
        //super.paint(g);
        g=getGraphics();
        drawFrame(g);
        drawTitleBar(g);
    }
}
