/* WWWParser.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    address:
           9526 Judson Rd.
           Ravenna, MI 49451
 */

import InfoFrame;
import Filters;
import QSortAlgorithm;
import OptionsFrame;
import GraphCanvas;
import LogFrame;
import WWWTransfer;
import SortableVector;

import java.awt.*;
import java.applet.*;
import java.util.*;
import java.net.*;
import java.io.*;

interface ThreadKeeper {
    public boolean getKeepRunning();
    public TextField getStatusField();
}

public class WWWParser extends Object implements Values {
    protected String www_transfers_name="www_transfers";
    protected SortableVector transferList;
    //protected String codeBase;
    protected URL transfersURL;
    protected Vector retList=null;
    protected String oldOptions=null;
    protected Filters filterFrame;
    protected List fFilter, sFilter;
    protected int maxValue;
        
    private static String optionTokens=" "; // currently this can only be " " [Oct,4,1997]

    public static String weekly=" Weekly ";
    public static String week=" Week ";
    public static String averageWeek=" AvgWeek ";

    public boolean recount=false;

    public boolean categorizeUA=false;
    
    public boolean getRecount() { return recount; }
    public void setRecount(boolean to) { recount=to; }

 
    WWWParser(URL fileURL, boolean sortLog, String collapseItems, int logFormat, boolean categorizeUA, ThreadKeeper threadKeeper) {
        String www_transfers_url;
        String server;
        WWWTransfer transfer;
        InputStream transfersStream;
        int tokeRet;
        StreamTokenizer tokeTransfers;
        CountryCodeTable cTable;
        int loop=1;
        int showEvery=25;
        Hashtable collapsers=new Hashtable();
        
        if(collapseItems !=null) {
            if(collapseItems.length()>0) {
                String key, value;
                StringTokenizer itemToke;
                StringTokenizer groupToke=new StringTokenizer(collapseItems, ",");
                while(groupToke.hasMoreTokens()) {
                    itemToke=new StringTokenizer(groupToke.nextToken(), " \t\n\r");
                    value=null;
                    if(itemToke.hasMoreTokens()) {
                        value=itemToke.nextToken();
                    }
                    while(itemToke.hasMoreTokens() && value!=null) {
                        key=itemToke.nextToken();
                        collapsers.put(key, value);
                    }
                }
            }
        }

        fFilter=null;
        sFilter=null;
        transfersURL=fileURL;
        www_transfers_name=transfersURL.getFile();
        server=transfersURL.getHost();
        
        transferList=new SortableVector();
        
        www_transfers_url=transfersURL.toString();
        System.out.println("www_transfers_url: "+www_transfers_url);

        try {
            transfersStream=transfersURL.openStream();
        } catch(java.io.IOException e) {
            System.out.println("getContent: "+e.getMessage());
            return;
        }
        System.out.println("transfersStream: "+transfersStream);
        
        /* I really wish I could use the new 1.1 stuff here.
           It's so much easier. */
        tokeTransfers=new StreamTokenizer(transfersStream);
        tokeTransfers.resetSyntax();
        tokeTransfers.wordChars('\u0000','\u00FF');

        tokeTransfers.eolIsSignificant(false);
        tokeTransfers.whitespaceChars('\r','\r');
        tokeTransfers.whitespaceChars('\n','\n');
        
        tokeRet=tokeTransfers.TT_EOF;
        try {
            tokeRet=tokeTransfers.nextToken();
        } catch(IOException e) {
            System.out.println(e.getMessage());
        }
        //System.out.println("line read: "+tokeTransfers.sval);
        
        try {
            cTable=new CountryCodeTable(new URL(fileURL, CountryCodeTable.defTableName));
        } catch(Exception e) {
            System.out.println("Error: "+e.getMessage());
            cTable=new CountryCodeTable();
        }
        
        if(tokeTransfers.sval!=null) {
            transfer=new WWWTransfer(server,tokeTransfers.sval, logFormat, collapsers);
            transfer.setCountryCodeTable(cTable);
            transfer.setCategorizeUA(categorizeUA);
            transferList.addElement(transfer);
        }
        while(tokeRet!=tokeTransfers.TT_EOF && threadKeeper.getKeepRunning()) {
            if((loop%showEvery)==0)
                threadKeeper.getStatusField().setText("www_transfers: accesses loaded: "+loop);
            loop++;               
            try {
                tokeRet=tokeTransfers.nextToken();
            } catch(Exception e) {
                System.out.println(e.getMessage());
            }
            if(tokeTransfers.sval!=null) {
                transfer=new WWWTransfer(server,tokeTransfers.sval, logFormat, collapsers);
                transfer.setCountryCodeTable(cTable);
                transfer.setCategorizeUA(categorizeUA);                
                transferList.addElement(transfer);
            }
        }
        
        if(sortLog) {
            CompareTransferDates comparer=new CompareTransferDates();
            transferList.sort(comparer);
        }
    }
    
    public Vector getTransfers(String options, String tranFor)
    {
        StringTokenizer optionsTokenizer;
        String category,show;
        Vector ret;
        WWWTransfer el;
        
        ret=new Vector();

        optionsTokenizer=new StringTokenizer(options, optionTokens);
        
        try {
            category=optionsTokenizer.nextToken();
            show=optionsTokenizer.nextToken();
        } catch(NoSuchElementException e) {
            System.out.println(e.getMessage());
            return ret;
        }
        
        if(category.equals(WWWTransfer.accesses)) {

            if(show.equals(week.trim())) {
                for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                    el=(WWWTransfer)(e.nextElement());
                    if(tranFor.regionMatches(0,el.getDateAccessed().toString(), 0, 10)) {
                        ret.addElement(el);
                    }
                }
            }
            else {
                for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                    el=(WWWTransfer)(e.nextElement());
                    if(tranFor.regionMatches(8,el.getDateAccessed().toString(), 0, 10)) {
                        ret.addElement(el);
                    }
                }            
            }
            
            return ret;
        }
        /*** uncomment for safe, easy modifying of the code
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(el.getStringInfo(category).equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        *****/
/**************** uncomment for speed */
        if(category.equals(WWWTransfer.sites)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(el.getClientHost().equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
    
        if(category.equals(WWWTransfer.domains)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(el.getDomain().equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
        if(category.equals(WWWTransfer.items)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(el.getFileURL().equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
        if(category.equals(WWWTransfer.codes)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(el.getServerResponse().equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
        if(category.equals(WWWTransfer.clients)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(((String)el.getClientInfo()).equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
        if(category.equals(WWWTransfer.rfc931)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(((String)el.getRFC931Info()).equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
        if(category.equals(WWWTransfer.authUser)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(((String)el.getAuthUserInfo()).equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
        if(category.equals(WWWTransfer.referers)) {
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                if(((String)el.getRefererInfo()).equals(tranFor)) {
                    ret.addElement(el);
                }
            }
            return ret;
        }
        return ret;
/***********************/
    }
    
    /* this is awful */
    public void setFilterFrame(Filters to) { filterFrame=to; fFilter=filterFrame.fileFilterList; sFilter=filterFrame.siteFilterList; }
/*    
    public void setFilter(List to) { filter=to; }
    public List getFilter() { return filter; }
 */   
    public int numberOfWeeks() {
        int ret=0, dayoweek=-1, t;
        WWWTransfer el;
        Date tDate, zDate=null;

        ret=1;
        for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
            el=(WWWTransfer)(e.nextElement());
            tDate=el.getDateAccessed();
            t=tDate.getDay();
            if(t<dayoweek) {
                ret++;
            }
            dayoweek=t;
        }
        return ret;
    }
    
    private boolean checkBlock(WWWTransfer el) {
        boolean block=false;
        int loop;
        
        if(filterFrame.filterSites && filterFrame.filterFiles) {
            for(loop=0;!block && loop<fFilter.countItems();loop++) {
                String it;
                it=fFilter.getItem(loop);
                block=(el.getFileURL().endsWith(it));
            }
            for(loop=0;!block && loop<sFilter.countItems();loop++) {
                String it;
                it=sFilter.getItem(loop);
                block=(el.getClientHost().endsWith(it));
            }
        } else if(!filterFrame.filterSites && filterFrame.filterFiles) {
            for(loop=0;!block && loop<fFilter.countItems();loop++) {
                String it;
                it=fFilter.getItem(loop);
                block=(el.getFileURL().endsWith(it));
            }
        } else if(!filterFrame.filterFiles && filterFrame.filterSites) {
            for(loop=0;!block && loop<sFilter.countItems();loop++) {
                String it;
                it=sFilter.getItem(loop);
                block=(el.getClientHost().endsWith(it));
            }
        }
        
        return block;
    }
    
    public Vector getValues(String options) {
        StringTokenizer optionsTokenizer;
        String category, show;
        int weeknum;
        Hashtable valueHash=null;
        boolean category_equals_accesses=true;
        boolean category_equals_kBytes=false;
        //QSortAlgorithm sortAlg;
        //CompareValues comparer;
        String weekDays[]=new String[7];
        
        if((oldOptions!=null && oldOptions.equals(options)) && (retList!=null) && recount==false) {
            return retList;
        }
        
        weekDays[0]="Sunday";
        weekDays[1]="Monday";
        weekDays[2]="Tuesday";
        weekDays[3]="Wednesday";
        weekDays[4]="Thursday";
        weekDays[5]="Friday";
        weekDays[6]="Saturday";
        
        //System.out.println("getValues");
        recount=false;
        oldOptions=new String(options);
        maxValue=-1;
        
        optionsTokenizer=new StringTokenizer(options, optionTokens);
        
        try {
            category=optionsTokenizer.nextToken().intern();
            show=optionsTokenizer.nextToken().intern();
        } catch(NoSuchElementException e) {
            System.out.println(e.getMessage());
            return null;
        }
        category_equals_accesses=(category.equals(WWWTransfer.accesses) || category.equals(WWWTransfer.kBytes));
        category_equals_kBytes=category.equals(WWWTransfer.kBytes);
        
        retList=new Vector();
        if(!category_equals_accesses) {
            //comparer=new CompareValues();
            //sortAlg=new QSortAlgorithm();
            valueHash=new Hashtable();
        }
        
        if(show.equals(week.trim())) {
            int dayoweek=-1, t, ret=0, loop;
            WWWTransfer el;
            Date tDate, zDate=null;
            Value weekValue;
            boolean block=false;
            Enumeration eT=transferList.elements();

            // do week
            try {
                weeknum=Integer.parseInt(optionsTokenizer.nextToken());
            } catch(NumberFormatException e) {
                System.out.println(e.getMessage());
                return null;
            } catch(NoSuchElementException e) {
                System.out.println(e.getMessage());
                return null;
            }
            
            // go to weeknum
            ret=1;
            el=null;
            t=-1;
            while(eT.hasMoreElements() && ret!=weeknum) {
                el=(WWWTransfer)(eT.nextElement());
                tDate=el.getDateAccessed();
                t=tDate.getDay();
                                
                //System.out.print(" "+tDate.toString());
                //if(dayoweek==-1) {
                    //ret=1;
                    //zDate=tDate;
                //} else 
                if(dayoweek>t) {//t && zDate.getMonth()!=tDate.getMonth() && zDate.getDate()!=tDate.getDate()) {
                    //new week
                    ret++;
                }
                dayoweek=t;
            }
            
            weekValue=new Value();
            if(el!=null) {
                tDate=el.getDateAccessed();
                t=tDate.getDay();
                
                block=checkBlock(el);
                if(!block) {
                    if(category_equals_kBytes) {
                        weekValue.value+=el.getBytesRead();
                    } else {
                        weekValue.value++;
                    }
                
                    if(!category_equals_accesses) {
                    /****** uncomment for safer coding
                        valueHash.put(el.getStringInfo(category), weekValue);
                    *********/
                    /******** uncomment for speed */
                    if(category.equals(WWWTransfer.domains)) {
                        valueHash.put(el.getDomain(),weekValue);
                    }
                    else if(category.equals(WWWTransfer.sites)) {
                        valueHash.put(el.getClientHost(),weekValue);
                    }
                    else if(category.equals(WWWTransfer.items)) {
                        valueHash.put(el.getFileURL(),weekValue);
                    }
                    else if(category.equals(WWWTransfer.clients)) {
                        valueHash.put(el.getClientInfo(),weekValue);
                    }
                    else if(category.equals(WWWTransfer.rfc931)) {
                        valueHash.put(el.getRFC931Info(),weekValue);
                    }
                    else if(category.equals(WWWTransfer.authUser)) {
                        valueHash.put(el.getAuthUserInfo(),weekValue);
                    }
                    else if(category.equals(WWWTransfer.referers)) {
                        valueHash.put(el.getRefererInfo(),weekValue);
                    }
                    else if(category.equals(WWWTransfer.codes)) {
                        valueHash.put(el.getServerResponse(),weekValue);
                    }
                    /*******************/
                    }
                }
            }
            ret=1;
            dayoweek=t;
            while(eT.hasMoreElements() && ret==1) {
                el=(WWWTransfer)(eT.nextElement());
                tDate=el.getDateAccessed();
                t=tDate.getDay();
                
                if(zDate==null)
                    zDate=tDate;                
                
                block=checkBlock(el);
                /*
                for(loop=0;!block && loop<filter.countItems();loop++) {
                    block=el.getFileURL().endsWith(filter.getItem(loop));
                }
                */
                //System.out.print(" "+tDate.toString());
                
                if(!block) {
                if(!category_equals_accesses) {
                /********* uncomment for safer coding
                        weekValue=(Value)valueHash.get(el.getStringInfo(category));
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getStringInfo(category),weekValue);
                        }
                ************/
                /*********** uncomment for speed */
                    if(category.equals(WWWTransfer.domains)) {
                        weekValue=(Value)valueHash.get(el.getDomain());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getDomain(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.sites)) {
                        weekValue=(Value)valueHash.get(el.getClientHost());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getClientHost(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.items)) {
                        weekValue=(Value)valueHash.get(el.getFileURL());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getFileURL(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.clients)) {
                        weekValue=(Value)valueHash.get(el.getClientInfo());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getClientInfo(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.rfc931)) {
                        weekValue=(Value)valueHash.get(el.getRFC931Info());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getRFC931Info(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.authUser)) {
                        weekValue=(Value)valueHash.get(el.getAuthUserInfo());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getAuthUserInfo(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.referers)) {
                        weekValue=(Value)valueHash.get(el.getRefererInfo());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getRefererInfo(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.codes)) {
                        weekValue=(Value)valueHash.get(el.getServerResponse());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getServerResponse(),weekValue);
                        }
                    }
                    /*************/
                } // category != accesses
                } // !blocked
                
                if(!eT.hasMoreElements()) {
                    if(!block) {
                        if(category_equals_kBytes) {
                            weekValue.value+=el.getBytesRead();
                        } else {
                            weekValue.value++;
                        }
                    }
                }

                if(dayoweek<0)
                    dayoweek=t;

                if(dayoweek!=t || !eT.hasMoreElements()) {// && zDate.getMonth()!=tDate.getMonth() && zDate.getDate()!=tDate.getDate()) {
                    //new day
                    if(dayoweek>t) { // new week
                        ret=0;
                    }
                    
                    //System.out.println("dayoweek: "+dayoweek);
                    weekValue.description=zDate.toString(); //weekDays[dayoweek];
                        if(category_equals_kBytes)
                            weekValue.value=weekValue.value/1024;
                    if(weekValue.value>maxValue)
                        maxValue=weekValue.value;
                    
                    if(category_equals_accesses) {
                        retList.addElement(weekValue);
                        weekValue=new Value();
                    }
                    dayoweek=t;
                    zDate=tDate;
                }
                if(!block) {
                    if(category_equals_kBytes) {
                        weekValue.value+=el.getBytesRead();
                    } else {
                        weekValue.value++;
                    }
                }
            }
        }
        else if(show.equals(weekly.trim())) {
            int dayoweek=-1, t, ret=0, loop;
            WWWTransfer el;
            Date tDate, zDate=null;
            Value weekValue;
            boolean block=false;

            //System.out.println("weekly");

            weekValue=new Value();
            
            ret=1;
            for (Enumeration e = transferList.elements() ; e.hasMoreElements() ;) {
                el=(WWWTransfer)(e.nextElement());
                tDate=el.getDateAccessed();
                t=tDate.getDay();
                
                if(zDate==null)
                    zDate=tDate;
                
                block=checkBlock(el);

                if(!block) {
                if(!category_equals_accesses) {
                /*********** uncomment for safer coding
                        weekValue=(Value)valueHash.get(el.getStringInfo(category));
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getStringInfo(category),weekValue);
                        }
                ************/
                /*********** uncomment for speed */
                    if(category.equals(WWWTransfer.domains)) {
                        weekValue=(Value)valueHash.get(el.getDomain());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getDomain(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.sites)) {
                        weekValue=(Value)valueHash.get(el.getClientHost());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getClientHost(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.items)) {
                        weekValue=(Value)valueHash.get(el.getFileURL());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getFileURL(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.clients)) {
                        weekValue=(Value)valueHash.get(el.getClientInfo());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getClientInfo(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.rfc931)) {
                        weekValue=(Value)valueHash.get(el.getRFC931Info());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getRFC931Info(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.authUser)) {
                        weekValue=(Value)valueHash.get(el.getAuthUserInfo());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getAuthUserInfo(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.referers)) {
                        weekValue=(Value)valueHash.get(el.getRefererInfo());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getRefererInfo(),weekValue);
                        }
                    }
                    else if(category.equals(WWWTransfer.codes)) {
                        weekValue=(Value)valueHash.get(el.getServerResponse());
                        if(weekValue==null) {
                            weekValue=new Value();
                            valueHash.put(el.getServerResponse(),weekValue);
                        }
                    }
                    /**************/
                } // category != accesses
                } // !blocked


                if(!e.hasMoreElements()) {
                    if(!block) {
                        if(category_equals_kBytes) {
                            weekValue.value+=el.getBytesRead();
                        } else {
                            weekValue.value++;
                        }
                    }
                }

                if(dayoweek>t || !e.hasMoreElements()) {// && zDate.getMonth()!=tDate.getMonth() && zDate.getDate()!=tDate.getDate()) {
                    //new week
                    //dayoweek=t;
                    ret++;
                    weekValue.description="Week of "+zDate.toString(); //Integer.toString(ret);
                        if(category_equals_kBytes)
                            weekValue.value=weekValue.value/1024;
                    if(weekValue.value>maxValue)
                        maxValue=weekValue.value;
                    if(category_equals_accesses) {
                        retList.addElement(weekValue);
                        weekValue=new Value();
                    }
                }
                zDate=tDate;
                if(!block) {
                    if(category_equals_kBytes) {
                        weekValue.value+=el.getBytesRead();
                    } else {
                        weekValue.value++;
                    }
                }
                dayoweek=t;
            }
        }
        else if(show.equals(averageWeek.trim())) {
            int dayoweek=-1, t, ret=0, loop;
            WWWTransfer el;
            Date tDate, zDate=null;
            boolean block=false;
            Enumeration eT=transferList.elements();
            Value avgDay[] = new Value[7];
            
            for(loop=0;loop<7;loop++)
                avgDay[loop]=new Value();
            
            ret=0;
            dayoweek=-1;
            while(eT.hasMoreElements()) {
                el=(WWWTransfer)(eT.nextElement());
                tDate=el.getDateAccessed();
                t=tDate.getDay();
                block=checkBlock(el);
                
                if(!block) {
                if(!category_equals_accesses) {
                /*********** uncomment for safer coding
                        avgDay=(Value[])valueHash.get(el.getStringInfo(category));
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getStringInfo(category),avgDay);
                        }
                *************/
                /************* uncomment for speed */
                    if(category.equals(WWWTransfer.domains)) {
                        avgDay=(Value[])valueHash.get(el.getDomain());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getDomain(),avgDay);
                        }
                    }
                    else if(category.equals(WWWTransfer.sites)) {
                        avgDay=(Value[])valueHash.get(el.getClientHost());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getClientHost(),avgDay);
                        }
                    }
                    else if(category.equals(WWWTransfer.items)) {
                        avgDay=(Value[])valueHash.get(el.getFileURL());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getFileURL(),avgDay);
                        }
                    }
                    else if(category.equals(WWWTransfer.clients)) {
                        avgDay=(Value[])valueHash.get(el.getClientInfo());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getClientInfo(),avgDay);
                        }
                    }
                    else if(category.equals(WWWTransfer.rfc931)) {
                        avgDay=(Value[])valueHash.get(el.getRFC931Info());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getRFC931Info(),avgDay);
                        }
                    }
                    else if(category.equals(WWWTransfer.authUser)) {
                        avgDay=(Value[])valueHash.get(el.getAuthUserInfo());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getAuthUserInfo(),avgDay);
                        }
                    }
                    else if(category.equals(WWWTransfer.referers)) {
                        avgDay=(Value[])valueHash.get(el.getRefererInfo());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getRefererInfo(),avgDay);
                        }
                    }
                    else if(category.equals(WWWTransfer.codes)) {
                        avgDay=(Value[])valueHash.get(el.getServerResponse());
                        if(avgDay==null) {
                            avgDay=new Value[7];
                            for(loop=0;loop<7;loop++)
                                avgDay[loop]=new Value();
                            valueHash.put(el.getServerResponse(),avgDay);
                        }
                    }
                    /*****************/
                } // category != accesses
                } // !blocked
                
                if(!block) {
                    if(category_equals_kBytes) {
                        avgDay[t].value+=el.getBytesRead();
                    } else {
                        avgDay[t].value++;
                    }
                }
            }
            ret=numberOfWeeks();
            if(!category_equals_accesses) {
            for(Enumeration e=valueHash.keys();e.hasMoreElements();) {
                String key;
                Value weekValue;
                
                key=(String)e.nextElement();
                weekValue=new Value();
                avgDay=(Value[])valueHash.get(key);
                
                for(loop=0;loop<7;loop++) 
                    weekValue.value+=avgDay[loop].value;
                weekValue.value=weekValue.value/ret;
                if(maxValue<weekValue.value)
                    maxValue=weekValue.value;

                valueHash.put(key,weekValue);
            }
            }
            else {
            for(loop=0;loop<7;loop++) {
                avgDay[loop].value=avgDay[loop].value/ret;
                if(category_equals_kBytes)
                    avgDay[loop].value=avgDay[loop].value/1024;
                if(maxValue<avgDay[loop].value)
                    maxValue=avgDay[loop].value;
                avgDay[loop].description=weekDays[loop];
                retList.addElement(avgDay[loop]);
            }
            }
        }

        if(!category_equals_accesses) {        
            for(Enumeration e=valueHash.keys();e.hasMoreElements();) {
                String key;
                Value weekValue;
                
                key=(String)e.nextElement();
                weekValue=(Value)valueHash.get(key);
                weekValue.description=key;
                if(category_equals_kBytes)
                    weekValue.value=weekValue.value/1024;
                if(weekValue.value>maxValue)
                    maxValue=weekValue.value;
                retList.addElement(weekValue);
            }
        }
        return retList;
    }
    
    public int getMaxValue() { return maxValue; }
}
