// {$R InfoFrame.JFM}

/* infoFrame.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    * updated October 30, 1997.
 */
 
import java.awt.*;
import java.applet.*;
import java.net.*;

// Class InfoFrame
public class InfoFrame extends Frame
{
    final int MenuBarHeight = 0;
    boolean fForm_Create;

    // Component Declaration
    public Label titleLabel;
    public Label copyrightLabel;
    public TextArea gnuNotice;
    public Label rightsLabel;
    public Label checkLabel;
    public Button mailButton;
    public Button webButton;
    public Label addressLabel;
    public Label streetLabel;
    public Label cityStateLabel;
    public Panel northPanel;
    public Panel innerAddressPanel;
    public Panel addressPanel;
    public Panel titlePanel;
    public Panel copyRightPanel;
    public Panel centerPanel;
    public Panel southPanel;
    public Label Label1;
    public Label Label2;
    public Label Label3;
    // End of Component Declaration

    public Applet myAppl;

    // Constructor
    public InfoFrame(String Title1, String Title2)
    {
        myAppl=GlobalVillage.appl;
        // Frame Initialization
        setForeground(Color.black);
        setBackground(Color.orange);
        setFont(new Font("Helvetica",Font.BOLD,12));
        setTitle(Title1+" "+Title2);
        setLayout(new BorderLayout());
        // End of Frame Initialization

        setIconImage(GlobalVillage.iconImage);

        // Component Initialization
        titleLabel = new Label(Title1,Label.LEFT);
        titleLabel.setFont(new Font("Dialog",Font.BOLD + Font.ITALIC,24));
        copyrightLabel = new Label("Copyright (c) 1997 by Bill Bereza.",Label.LEFT);
        copyrightLabel.setFont(new Font("Dialog",Font.BOLD,12));
        gnuNotice = new TextArea("This software comes with ABSOLUTELY NO WARRANTY.\nThis is free software, and you are welcome to redistribute it\nunder certain conditions.");
        gnuNotice.setForeground(Color.black);
        gnuNotice.setBackground(Color.white);
        gnuNotice.setFont(new Font("TimesRoman",Font.PLAIN,12));
        rightsLabel = new Label("All Rights Reserved.",Label.LEFT);
        rightsLabel.setFont(new Font("Dialog",Font.BOLD,12));
        checkLabel = new Label(Title2,Label.RIGHT);
        checkLabel.setFont(new Font("Dialog",Font.BOLD + Font.ITALIC,24));
        mailButton = new Button("mailto:bereza@pobox.com");
        mailButton.setFont(new Font("Dialog",Font.PLAIN,10));
        webButton = new Button("http://www.pobox.com/~bereza");
        webButton.setFont(new Font("Dialog",Font.PLAIN,10));
        addressLabel = new Label("Address",Label.LEFT);
        addressLabel.setFont(new Font("Dialog",Font.BOLD,10));
        streetLabel = new Label("9526 Judson Rd.",Label.LEFT);
        streetLabel.setFont(new Font("Dialog",Font.PLAIN,10));
        cityStateLabel = new Label("Ravenna, MI 49451",Label.LEFT);
        cityStateLabel.setFont(new Font("Dialog",Font.PLAIN,10));
        northPanel = new Panel();
        northPanel.setLayout(new BorderLayout(20,20));
        northPanel.setForeground(Color.black);
        northPanel.setBackground(Color.orange);
        northPanel.setFont(new Font("Dialog",Font.BOLD,12));
        innerAddressPanel = new Panel();
        innerAddressPanel.setLayout(new BorderLayout());
        innerAddressPanel.setForeground(Color.black);
        innerAddressPanel.setBackground(Color.orange);
        innerAddressPanel.setFont(new Font("Dialog",Font.BOLD,12));
        addressPanel = new Panel();
        addressPanel.setLayout(new BorderLayout());
        addressPanel.setForeground(Color.black);
        addressPanel.setBackground(Color.orange);
        addressPanel.setFont(new Font("Dialog",Font.BOLD,12));
        titlePanel = new Panel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setForeground(Color.black);
        titlePanel.setBackground(Color.orange);
        titlePanel.setFont(new Font("Dialog",Font.BOLD,12));
        copyRightPanel = new Panel();
        copyRightPanel.setLayout(new BorderLayout());
        copyRightPanel.setForeground(Color.black);
        copyRightPanel.setBackground(Color.orange);
        copyRightPanel.setFont(new Font("Dialog",Font.BOLD,12));
        centerPanel = new Panel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.setForeground(Color.black);
        centerPanel.setBackground(Color.yellow);
        centerPanel.setFont(new Font("Dialog",Font.BOLD,12));
        southPanel = new Panel();
        southPanel.setLayout(new BorderLayout());
        southPanel.setForeground(Color.black);
        southPanel.setBackground(Color.white);
        southPanel.setFont(new Font("Dialog",Font.BOLD,12));
        Label1 = new Label("This software comes with ABSOLUTELY NO WARRANTY.",Label.LEFT);
        Label1.setFont(new Font("TimesRoman",Font.PLAIN,10));
        Label2 = new Label("This is free software, and you are welcome to redistribute it",Label.LEFT);
        Label2.setFont(new Font("TimesRoman",Font.PLAIN,10));
        Label3 = new Label("under certain conditions.",Label.LEFT);
        Label3.setFont(new Font("TimesRoman",Font.PLAIN,10));
        // End of Component Initialization

        gnuNotice.setEditable(false);

        // Add()s
        southPanel.add("South", Label3);
        southPanel.add("Center", Label2);
        southPanel.add("North", Label1);
        add("South", southPanel);
        add("Center", centerPanel);
     //   add(copyRightPanel);
     centerPanel.add("South", copyRightPanel);
     centerPanel.add("Center", titlePanel);
     // centerPanel.add("East", addressPanel);
     //   add(titlePanel);
     //   add(addressPanel);
     addressPanel.add("Center", innerAddressPanel);
     addressPanel.add("North", addressLabel);
     //   add(innerAddressPanel);
     innerAddressPanel.add("North", streetLabel);
     innerAddressPanel.add("South", cityStateLabel);
        add("North", northPanel);
     northPanel.add("East", mailButton);
     northPanel.add("West", webButton);
     //southPanel.add("Center", gnuNotice);
     
     copyRightPanel.add("North", copyrightLabel);
     copyRightPanel.add("South", rightsLabel);
     
     titlePanel.add("North", titleLabel);
     titlePanel.add("South", checkLabel);
     //   add(cityStateLabel);
     //   add(streetLabel);
     //   add(addressLabel);
     //   add(webButton);
     //   add(mailButton);
     //   add(checkLabel);
     //   add(rightsLabel);
     //   add(gnuNotice);
     //   add(copyrightLabel);
     //   add(titleLabel);
        // End of Add()s

        fForm_Create = true;
    }

    public void InitialPositionSet()
    {
        // InitialPositionSet()
        reshape(172,105,376,266); /*
        titleLabel.reshape(30,78+MenuBarHeight,100,36);
        copyrightLabel.reshape(30,158+MenuBarHeight,256,21);
        gnuNotice.reshape(24,209+MenuBarHeight,355,87);
        rightsLabel.reshape(31,179+MenuBarHeight,173,19);
        checkLabel.reshape(29,114+MenuBarHeight,168,35);
        mailButton.reshape(164,27+MenuBarHeight,186,19);
        webButton.reshape(164,51+MenuBarHeight,186,20);
        addressLabel.reshape(171,78+MenuBarHeight,51,16);
        streetLabel.reshape(229,80+MenuBarHeight,94,16);
        cityStateLabel.reshape(230,101+MenuBarHeight,120,19);
        northPanel.reshape(26,23+MenuBarHeight,185,41);
        innerAddressPanel.reshape(254,87+MenuBarHeight,185,41);
        addressPanel.reshape(179,121+MenuBarHeight,185,41);
        titlePanel.reshape(11,94+MenuBarHeight,185,41);
        copyRightPanel.reshape(35,158+MenuBarHeight,185,41);
        centerPanel.reshape(0,196+MenuBarHeight,23,41);
        southPanel.reshape(97,299+MenuBarHeight,185,54);
        
 Label1.reshape(11,0,170,19);
 Label2.reshape(15,13,149,19);
 Label3.reshape(22,30,51,19);
 */       // End of InitialPositionSet()

        fForm_Create = false;
    }

    public boolean handleEvent(Event evt)
    {
        // handleEvent()
        if (evt.id == Event.WINDOW_DESTROY && evt.target == this) InfoFrame_WindowDestroy(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == mailButton) mailButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == webButton) webButton_Action(evt.target);
        // End of handleEvent()

        return super.handleEvent(evt);
    }

    public void paint(Graphics g)
    {
        // paint()
        // End of paint()
        if (fForm_Create) InitialPositionSet();
    }

    // Event Handling Routines
    public void InfoFrame_WindowDestroy(Object target)
    {
        hide();
    }

    public void mailButton_Action(Object target)
    {
        Button me=(Button)target;
        URL mailURL;
        AppletContext apc;
        try {
            mailURL=new URL(me.getLabel());
        } catch(MalformedURLException e) {
            System.out.println(e.getMessage());
            return;
        }
        if(myAppl!=null) {
            apc=myAppl.getAppletContext();
            apc.showDocument(mailURL, me.getLabel());
        }
    }

    public void webButton_Action(Object target)
    {
        Button me=(Button)target;
        URL webURL;
        AppletContext apc;
        
        try {
            webURL=new URL(me.getLabel());
        } catch(MalformedURLException e) {
            System.out.println(e.getMessage());
            return;
        }
        
        if(myAppl!=null) {
            apc=myAppl.getAppletContext();
            apc.showDocument(webURL, me.getLabel());
        }
    }

    // End of Event Handling Routines

} // End of Class InfoFrame

