// {$R Filters.JFM}


/* Filters.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    address:
           9526 Judson Rd.
           Ravenna, MI 49451
*/

import Values;
import OptionTaking;
import java.awt.*;
import java.util.Enumeration;
import java.util.Vector;

// Class Filters
public class Filters extends Frame
{
    final int MenuBarHeight = 0;
    boolean fForm_Create;

    // Component Declaration
    public Panel filterPanel;
    public List filterList, fileFilterList, siteFilterList;
    public TextField filterField;
    public Panel addPanel;
    public Panel buttonsPanel;
    public Panel changePanel;
    public Button addButton;
    public Button removeButton2;
    public Button changeButton;
    public Panel newPanel;
    public Button removeButton1;
    public Button newButton;
    public Checkbox filesBox;
    public Checkbox sitesBox;
    public Panel buttonHolderPanel;
    public Panel switcherPanel;
    public CheckboxGroup CheckboxGrpInswitcherPanel;
    public Checkbox filesButton;
    public Checkbox sitesButton;
    public Checkbox enabledBox;
    // End of Component Declaration

    boolean add=true;
    public OptionTaking opter;
    public Values valler;
    public boolean filterFiles;
    public boolean filterSites;

    // Constructor
    public Filters(OptionTaking opt, Values val, Vector fFilters, Vector sFilters, boolean fFiles, boolean fSites)
    {
        // Frame Initialization
        setForeground(Color.black);
        setBackground(Color.lightGray);
        setFont(new Font("Dialog",Font.BOLD,12));
        setTitle("Filters");
        setLayout(new BorderLayout());
        // End of Frame Initialization
        

        setIconImage(GlobalVillage.iconImage);



        // Component Initialization
        filterPanel = new Panel();
        filterPanel.setLayout(new BorderLayout());
        filterPanel.setForeground(Color.black);
        filterPanel.setBackground(Color.lightGray);
        filterPanel.setFont(new Font("Dialog",Font.BOLD,12));
        fileFilterList = new List();
        fileFilterList.setForeground(Color.black);
        fileFilterList.setBackground(Color.white);
        fileFilterList.setFont(new Font("Dialog",Font.PLAIN,12));
        siteFilterList=new List();
        siteFilterList.setForeground(Color.black);
        siteFilterList.setBackground(Color.white);
        siteFilterList.setFont(new Font("Dialog",Font.PLAIN,12));
        filterList=fileFilterList;
        filterField = new TextField("");
        filterField.setForeground(Color.black);
        filterField.setBackground(Color.white);
        filterField.setFont(new Font("Dialog",Font.PLAIN,12));
        addPanel = new Panel();
        addPanel.setLayout(new BorderLayout());
        addPanel.setForeground(Color.black);
        addPanel.setBackground(Color.lightGray);
        addPanel.setFont(new Font("Dialog",Font.BOLD,12));
        buttonsPanel = new Panel();
        buttonsPanel.setLayout(new CardLayout());
        buttonsPanel.setForeground(Color.black);
        buttonsPanel.setBackground(Color.lightGray);
        buttonsPanel.setFont(new Font("Dialog",Font.BOLD,12));
        changePanel = new Panel();
        changePanel.setLayout(new BorderLayout());
        changePanel.setForeground(Color.black);
        changePanel.setBackground(Color.lightGray);
        changePanel.setFont(new Font("Dialog",Font.BOLD,12));
        addButton = new Button("Add");
        addButton.setFont(new Font("Dialog",Font.BOLD,12));
        removeButton2 = new Button("Remove");
        removeButton2.setFont(new Font("Dialog",Font.PLAIN,12));
        changeButton = new Button("Change");
        changeButton.setFont(new Font("Dialog",Font.BOLD,12));
        newPanel = new Panel();
        newPanel.setLayout(new BorderLayout());
        newPanel.setForeground(Color.black);
        newPanel.setBackground(Color.lightGray);
        newPanel.setFont(new Font("Dialog",Font.BOLD,12));
        removeButton1 = new Button("Remove");
        removeButton1.setFont(new Font("Dialog",Font.PLAIN,12));
        newButton = new Button("New");
        newButton.setFont(new Font("Dialog",Font.BOLD,12));
        filesBox = new Checkbox("Files");
        filesBox.setBackground(Color.lightGray);
        filesBox.setFont(new Font("Dialog",Font.PLAIN,10));
        sitesBox = new Checkbox("Sites/Domains");
        sitesBox.setBackground(Color.lightGray);
        sitesBox.setFont(new Font("Dialog",Font.PLAIN,10));
        filesBox.setState(true);
        sitesBox.setState(true);
        buttonHolderPanel = new Panel();
        buttonHolderPanel.setLayout(new BorderLayout());
        buttonHolderPanel.setForeground(Color.black);
        buttonHolderPanel.setBackground(Color.lightGray);
        buttonHolderPanel.setFont(new Font("Dialog",Font.BOLD,12));
        switcherPanel = new Panel();
        switcherPanel.setLayout(new BorderLayout());
        switcherPanel.setForeground(Color.black);
        switcherPanel.setBackground(Color.lightGray);
        switcherPanel.setFont(new Font("Dialog",Font.BOLD,12));
        CheckboxGrpInswitcherPanel = new CheckboxGroup(); // CheckboxGroup in switcherPanel
        filesButton = new Checkbox("Files",CheckboxGrpInswitcherPanel,true);
        filesButton.setBackground(Color.lightGray);
        filesButton.setFont(new Font("Dialog",Font.PLAIN,10));
        sitesButton = new Checkbox("Sites",CheckboxGrpInswitcherPanel,false);
        sitesButton.setBackground(Color.lightGray);
        sitesButton.setFont(new Font("Dialog",Font.PLAIN,10));
      //  enabledBox = new Checkbox("Enabled");
      //  enabledBox.setBackground(Color.lightGray);
      //  enabledBox.setFont(new Font("Dialog",Font.PLAIN,10));
        // End of Component Initialization

        enabledBox=filesBox;

        // Add()s
        buttonHolderPanel.add("South",enabledBox);
        buttonHolderPanel.add("Center", buttonsPanel);
        switcherPanel.add("East",sitesButton);
        switcherPanel.add("West", filesButton);
        add("North", switcherPanel);
        add("South", buttonHolderPanel);
       // add(sitesBox);
       // add(filesBox);
        newPanel.add("East", newButton);
        newPanel.add("West", removeButton1);
        // add(newPanel);
        changePanel.add("East", changeButton);
        changePanel.add("West", removeButton2);
        addPanel.add("Center", addButton);
       // add(changePanel);
       // add(buttonsPanel);
       // add(addPanel);
        filterPanel.add("Center", filterList);
        filterPanel.add("South", filterField);
        add("Center", filterPanel);
        // End of Add()s

        buttonsPanel.add("add", addPanel);
        buttonsPanel.add("change", changePanel);
        buttonsPanel.add("new", newPanel);
        ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"add");
        add=true;
        
        for (Enumeration e = fFilters.elements() ; e.hasMoreElements() ;) { 
            fileFilterList.addItem((String)e.nextElement()); 
        } 
        for (Enumeration e = sFilters.elements() ; e.hasMoreElements() ;) { 
            siteFilterList.addItem((String)e.nextElement()); 
        } 

        filterFiles=fFiles;
        filterSites=fSites;
        removeButton1.disable();
        removeButton2.disable();
        filterField.requestFocus();
        validate(); layout();
        validate(); layout();
        
        opter=opt;
        valler=val;
        
        fForm_Create = true;
    }

    public void InitialPositionSet()
    {
        // InitialPositionSet()
        reshape(182,166,193,235);
/*        filterPanel.reshape(8,57+MenuBarHeight,190,153);
        filterList.reshape(8,8,174,100);
        filterField.reshape(8,114,174,27);
        addPanel.reshape(38,253+MenuBarHeight,190,41);
        buttonsPanel.reshape(6,212+MenuBarHeight,190,41);
        changePanel.reshape(136,292+MenuBarHeight,190,41);
        addButton.reshape(8,8,174,25);
        removeButton2.reshape(8,8,75,25);
        changeButton.reshape(107,8,75,25);
        newPanel.reshape(126,418+MenuBarHeight,190,41);
        removeButton1.reshape(8,8,75,25);
        newButton.reshape(107,8,75,25);
        filesBox.reshape(19,264+MenuBarHeight,51,17);
        sitesBox.reshape(107,266+MenuBarHeight,94,17);
        buttonHolderPanel.reshape(204,196+MenuBarHeight,185,48);
        switcherPanel.reshape(13,21+MenuBarHeight,185,34);
        filesButton.reshape(9,7,59,17);
        sitesButton.reshape(82,8,78,17);
        enabledBox.reshape(56,27,72,17);
        // End of InitialPositionSet()
*/
        fForm_Create = false;
    }

    public boolean handleEvent(Event evt)
    {
        // handleEvent()
        if (evt.id == Event.WINDOW_DESTROY && evt.target == this) Filters_WindowDestroy(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == filterList) filterList_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == filterField) filterField_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == changeButton) changeButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == addButton) addButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == removeButton2) removeButton2_Action(evt.target);
        else if (evt.id == Event.LIST_SELECT && evt.target == filterList) filterList_ListSelect(evt.target);
        else if (evt.id == Event.LIST_DESELECT && evt.target == filterList) filterList_ListDeSelect(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == newButton) newButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == removeButton1) removeButton2_Action(evt.target);
        else if (evt.id == Event.GOT_FOCUS && evt.target == filterField) filterField_GotFocus(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == filesBox) filesBox_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == sitesBox) sitesBox_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == filesButton) filesButton_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == sitesButton) sitesButton_Action(evt.target);
        else if (evt.id == Event.KEY_PRESS && evt.target == filterField) filterField_KeyPress(evt.target, evt.key, evt.modifiers);
        // End of handleEvent()

        return super.handleEvent(evt);
    }

    public void paint(Graphics g)
    {
        // paint()
        // End of paint()
        if (fForm_Create) InitialPositionSet();
    }

    // Event Handling Routines
    public void Filters_WindowDestroy(Object target)
    {
        hide();
    }

    public void filterList_ListSelect(Object target)
    {
        String t=((List)target).getSelectedItem();
        filterField.setText(t);
        ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"new");
        add=false;
        removeButton2.enable();
        removeButton1.enable();
    }
    
    public void filterList_ListDeSelect(Object target)
    {
        add=true;
        ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"add");
    }

    public void filterList_Action(Object target)
    {
        String t=((List)target).getSelectedItem();
        filterField.setText(t);
        ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"change");
        add=false;
        removeButton2.enable();
        removeButton1.enable();
        ((List)target).nextFocus();
    }

    public void filterField_GotFocus(Object target)
    {
        //System.out.println("filterField:got focus");
        if(add) {
            return;
        }
        ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"change");
    }
        
    public void filterField_Action(Object target)
    {
        //System.out.println("filterField:action");
        if(add) {
            addButton_Action(null);
        } else {
            changeButton_Action(null);
        }
    }

    public void changeButton_Action(Object target)
    {
        int ind;
        String t=filterField.getText();
        if((ind=filterList.getSelectedIndex())>=0 && (t!=null && !t.equals(""))) {
            filterList.replaceItem(t, ind);
            filterList.select(ind);
            filterList.requestFocus();
            ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"new");
            valler.setRecount(true);
            opter.setChanged(true);
        }
    }

    public void addButton_Action(Object target)
    {
        String t=filterField.getText();
        if(t!=null && !t.equals("")) {
            filterList.addItem(t);
            filterField.setText("");
            valler.setRecount(true);
            opter.setChanged(true);
        }
    }

    public void removeButton2_Action(Object target)
    {
        int ind;
        if((ind=filterList.getSelectedIndex())>=0) {
            filterList.delItem(ind);
            valler.setRecount(true);
            opter.setChanged(true);
            if(filterList.countItems()>0) {
                if(ind>0)
                    filterList.select(ind-1);
                else
                    filterList.select(0);
                filterField.setText(filterList.getSelectedItem());
                filterList.requestFocus();
                ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"new");
            }
            else {
                removeButton1.disable();
                removeButton2.disable();
                add=true;
                filterField.setText("");
                filterField.requestFocus();
                ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"add");
            }
        }
    }
    

    public void newButton_Action(Object target)
    {
        add=true;
        ((CardLayout)buttonsPanel.getLayout()).show(buttonsPanel,"add");
        filterField.setText("");
        filterField.requestFocus();
    }

    public void filesBox_Action(Object target)
    {
        filterFiles=((Checkbox)target).getState();
            valler.setRecount(true);
            opter.setChanged(true);        
    }

    public void sitesBox_Action(Object target)
    {
        filterSites=((Checkbox)target).getState();
            valler.setRecount(true);
            opter.setChanged(true);
    }

    public void filesButton_Action(Object target)
    {
        filterPanel.remove(filterList);
        filterList=fileFilterList;
        filterPanel.add("Center", filterList);
        buttonHolderPanel.remove(enabledBox);
        enabledBox=filesBox;
        buttonHolderPanel.add("South", enabledBox);
        validate(); layout();
        validate(); layout();
    }

    public void sitesButton_Action(Object target)
    {
        filterPanel.remove(filterList);
        filterList=siteFilterList;
        filterPanel.add("Center", filterList);
        buttonHolderPanel.remove(enabledBox);
        enabledBox=sitesBox;
        buttonHolderPanel.add("South", enabledBox);
        validate(); layout();
        validate(); layout();
    }

    public void filterField_KeyPress(Object target, int key, int modifiers)
    {
        filterField_GotFocus(target);
    }

    // End of Event Handling Routines

} // End of Class Filters
