/* CountryCodeTable.java
 * Copyright (c) 1997 Bill Bereza. All Rights Reserved.
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    Contact Bill Bereza:
    email: bereza@pobox.com
    url:   www.pobox.com/~bereza
    
    address:
           9526 Judson Rd.
           Ravenna, MI 49451
*/

import java.util.*;
import java.net.*;
import java.io.*;

public class CountryCodeTable extends Hashtable
{
    public static String defTableName="country-codes.txt";

    private void load_self(URL tableURL) {
        InputStream transfersStream;
        int tokeRet;
        StreamTokenizer tokeTransfers;
        String lineIn, code, name;

        try {
            transfersStream=tableURL.openStream();
        } catch(java.io.IOException e) {
            System.out.println("getContent: "+e.getMessage());
            return;
        }
        System.out.println("transfersStream: "+transfersStream);
        
        /* I really wish I could use the new 1.1 stuff here.
           It's so much easier. */
        tokeTransfers=new StreamTokenizer(transfersStream);
        tokeTransfers.resetSyntax();
        tokeTransfers.wordChars('\u0000','\u00FF');

        tokeTransfers.eolIsSignificant(false);
        tokeTransfers.whitespaceChars('\r','\r');
        tokeTransfers.whitespaceChars('\n','\n');
        
        tokeRet=tokeTransfers.TT_EOF;
        try {
            tokeRet=tokeTransfers.nextToken();
        } catch(IOException e) {
            System.out.println(e.getMessage());
        }
        
        if(tokeTransfers.sval!=null) {
            int spaceIndex;
            
            lineIn=tokeTransfers.sval;
            spaceIndex=lineIn.indexOf(' ');
            if(spaceIndex>0) {
                try {
                    code=lineIn.substring(0, spaceIndex).trim().toLowerCase();
                    name=lineIn.substring(spaceIndex).trim();
                    put(code.intern(), name.intern());
                } catch(Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        
        while(tokeRet!=tokeTransfers.TT_EOF) {
            try {
                tokeRet=tokeTransfers.nextToken();
            } catch(IOException e) {
                System.out.println(e.getMessage());
            }
            if(tokeTransfers.sval!=null) {
                int spaceIndex;
            
                lineIn=tokeTransfers.sval;
                spaceIndex=lineIn.indexOf(' ');
                if(spaceIndex>0) {
                    try {
                        code=lineIn.substring(0, spaceIndex).trim().toLowerCase();
                        name=lineIn.substring(spaceIndex).trim();
                        put(code.intern(), name.intern());
                    } catch(Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
        }        
    }

    CountryCodeTable()
    {
        super();

        Properties sysProp=System.getProperties();
        String table_url;
        URL tableURL;
        
        try { 
            table_url="file:///"+sysProp.getProperty("user.dir")+"/"+defTableName;
        } catch(Exception e) {
            System.out.println(e.getMessage());
            table_url=defTableName;
        }
        
        try {
            tableURL=new URL(table_url);
        } catch(MalformedURLException e) {
            System.out.println(e.getMessage());
            tableURL=null;
        }
        if(tableURL!=null)
            load_self(tableURL);
    }

    CountryCodeTable(URL tableURL)
    {
        super();
        if(tableURL!=null)
            load_self(tableURL);
    }
    
}

