
#import "Controller.h"
#import <misckit/MiscProgressPie.h>

static void stepHandler(DPSTimedEntry teNumber, double now, void *userData)
{
	id control=(id)userData;
	static int i=0;

	if([control num]>0) {
		[[control textObject] setIntValue:[control num]];
		[control setNum:[control num]-1];

		if(![control tick] || !([control num] % [control tick])) {
			[[control guage1] increment:control];
			[[control guage2] increment:control];
			[[control guage3] increment:control];
			[[control guage4] increment:control];
		}
	}
	else {
		i=!i;
		if(i) {
			[[control textObject] setStringValue:"XXXXXX"];

			/*
			[[control appView] lockFocus];
			[[control endImage] composite:NX_SOVER toPoint:[control aPoint]];
			[[control appView] unlockFocus];
			[[NXApp appIcon] flushWindow];
			*/
		}
		else {
			[[control textObject] setStringValue:""];

			/*
			[[control appView] lockFocus];
			[[control startImage] composite:NX_SOVER toPoint:[control aPoint]];
			[[control appView] unlockFocus];
			[[NXApp appIcon] flushWindow];
			*/
		}
	}
}

@implementation Controller

-init
{
	[super init];
	num=0;
	speed=0.02;
	return self;
}

-appDidInit:sender
{
	appImage=[[NXImage findImageNamed:"bomb2"] setScalable:YES];	
	startImage=[[NXImage findImageNamed:"bomb1"] setScalable:YES];
	imageList=[[List alloc] init];

	[imageList addObject:[[NXImage findImageNamed:"bomb1"] setScalable:YES]];
	[imageList addObject:[[NXImage findImageNamed:"bomb2"] setScalable:YES]];
	endImage=[[NXImage findImageNamed:"bomblast"] setScalable:YES];

	aPoint.x=8;
	aPoint.y=8;
	appView=[[NXApp appIcon] contentView];
	if(!appView) {
		printf("Couldn't get contentView\n");
	}

	
	[appView lockFocus];
	[startImage composite:NX_SOVER toPoint:&aPoint];
	[appView unlockFocus];

	[[NXApp appIcon] flushWindow];

	
	
	return self;
}

-appView { return appView; }
-(NXPoint *)aPoint { return &aPoint; }
-imageList { return imageList; }
-startImage { return startImage; }
-endImage { return endImage; }

-guage1 { return guage1; }
-guage2 { return guage2; }
-guage3 { return guage3; }
-guage4 { return guage4; }

-textObject { return textObject; }
-(int)num { return num; }
-setNum:(int)to { num=to; return self; }
-(int)tick { return tick; }

-takeNumFrom:sender
{	
	[self setNum:[sender intValue]];
	[[self textObject] setIntValue:[self num]];
	start=[self num];
	tick=[self num]/100;
	
	if(!tick) {
		[guage1 setStepSize:100/[self num]];
		[guage2 setStepSize:100/[self num]];
		[guage3 setStepSize:100/[self num]];
		[guage4 setStepSize:100/[self num]];
	}
	else {
		[guage1 setStepSize:1];
		[guage2 setStepSize:1];
		[guage3 setStepSize:1];
		[guage4 setStepSize:1];
	}
	[guage1 clear:self];
	[guage2 clear:self];
	[guage3 clear:self];
	[guage4 clear:self];

	return self;
}

-takeSpeedFrom:sender
{
	speed=[sender doubleValue];

	if(started && stepTE) {
		[self pushStart:nil];
		[self pushStart:nil];
	}

	return self;
}

- pushStart:sender
{
	if(started && stepTE) {
		started=NO;
		DPSRemoveTimedEntry(stepTE);
		stepTE=0;
		[[self textObject] setIntValue:[self num]];

		/*
		[appView lockFocus];
		[startImage composite:NX_SOVER toPoint:&aPoint];
		[appView unlockFocus];
		[[NXApp appIcon] flushWindow];
		*/
	}
	else {
		started=YES;
		stepTE = DPSAddTimedEntry(speed,(DPSTimedEntryProc)stepHandler,
								  self,NX_MODALRESPTHRESHOLD /* NX_BASETHRESHOLD */);
	}

    return self;
}

- showInfo:sender
{
	if(!infoPanel) {
		if(![NXApp
		   loadNibSection: "info.nib"
		   owner: self
		   withNames: NO]) {
			return nil;
		}
	}
	[infoPanel makeKeyAndOrderFront: nil];
	return self;
}

-windowWillClose:sender
{
	if(started) {
		[self pushStart:nil];
	}

	[NXApp terminate:self];
	return self;
}

@end
