
#import "Controller.h"
#import "CalcWindow.h"

char *ltob(unsigned long val, char *buf)
{
	int i;
	
	for(i=0;i<32;i++) {
		buf[i]=(val & (1<<(31-i)) ? '1' : '0');
	}
	buf[32]='\0';
	
	for(i=0;i<32;i++) {
		if(buf[i] != '0') return (&buf[i]);
	}
	return (&buf[31]);
}

@implementation Controller

- clear:sender
{
	X=0.0;
	[self displayX];
    return self;
}

- clearAll:sender
{
	X=0.0;
	Y=0.0;
	yFlag=0;
	enterFlag=0;
	[self displayX];
    return self;
}

- enterDigit:sender
{
	if(enterFlag) {
		Y=X;
		X=0.0;
		enterFlag=NO;
	}
	
	X=(X*radix) + [[sender selectedCell] tag];
	[self displayX];
    return self;
}

- enterOp:sender
{
	int newop=[[sender selectedCell] tag];
	
	if(yFlag) {
		switch(operation) {
		  case PLUS:
			X=Y+X;
			break;
			
		  case SUBTRACT:
			X=Y-X;
			break;
			
		  case MULTIPLY:
			X=Y*X;
			break;
			
		  case DIVIDE:
			X=Y/X;
			break;
		}
	}
	
	yFlag=YES;
	operation=newop;
	enterFlag=1;
	
	[self displayX];
    return self;
}

- displayX
{
	char buf[256];
	char bbuf[256];
	
	switch(radix) {
	  case 10:
		sprintf(buf, "%.10g", X);
		break;
	  case 16:
		sprintf(buf, "%x", (unsigned int)X);
		break;
	  case 8:
		sprintf(buf, "%o", (unsigned int)X);
		break;
	  case 2:
		strcpy(buf, ltob((int)X, bbuf));
		break;
	}
	
	[readout setStringValue: buf];
	return self;
}

-doUnaryMinus:sender
{
	X=-X;
	[self displayX];
	return self;
}

- showInfo:sender
{
	if(infoPanel==nil) {
		if(![NXApp
			 loadNibSection: "info.nib"
			 owner: self
			 withNames: NO]) {
			return nil;
		}
	}
	[infoPanel makeKeyAndOrderFront: nil];
	return self;
}

- showGPL:sender
{
	if(GPLPanel==nil) {
		if(![NXApp
			 loadNibSection: "COPYING.nib"
			 owner: self
			 withNames: NO]) {
			return nil;
		}
	}
	[GPLPanel makeKeyAndOrderFront: nil];
	return self;
}

- setRadix:sender
{
	int i;
	id cellList;
	int	oldRadix=radix;
	id	keyWindow=[keyPad window];
	
	radix=[[sender selectedCell] tag];
	
	/*
	 * Disable buttons higher than the radix.
	 */
	
	cellList=[keyPad cellList];
	
	for(i=0;i<[cellList count]; i++) {
		id cell = [cellList objectAt: i];
		[cell setEnabled: ([cell tag] < radix) ];
	}
	
	if(radix==16 && oldRadix!=16) {
		NXRect 	keyFrame;
		NXRect	newWindowFrame;
		[keyPad getFrame:&keyFrame];
		
		[keyWindow getFrame:&newWindowFrame];
		NX_WIDTH(&newWindowFrame) += 
		  NX_X(&keyFrame) + NX_WIDTH(&keyFrame)
			- NX_WIDTH(&originalViewSize)
			  + 4.0;
		
		[keyWindow
		 placeWindowAndDisplay:&newWindowFrame];
	}
	
	if(radix!=16 && oldRadix==16) {
		[keyWindow
		 sizeWindow:NX_WIDTH(&originalViewSize)
		 :NX_HEIGHT(&originalViewSize)];
	}
	
	[self displayX];
	return self;
}

@end

@implementation Controller (ApplicationDelegate)

- appDidInit:sender
{
	id kwin = [keyPad window];
	
	[self setRadix:radixMatrix];
	[self clearAll:self];
	
	[ [ kwin contentView]
	 getFrame:&originalViewSize];

	[kwin findButtons];
	
	[self showInfo:self];
	
	return self;
}
@end


