
#import "CalcWindow.h"

@implementation CalcWindow

-findButtons
{
	[keyTable empty];
	[self checkView:contentView];
	return self;
}

-checkView:aView
{
	id subViews = [aView subviews];
	int numSubView = [subViews count];
	int i;

	if([aView isKindOf:[Matrix class]]) {
		return [self checkMatrix:aView];
	}

	if([aView isKindOf:[Button class]]) {
		return [self checkButton:aView];
	}

	for(i=0;i<numSubView;i++) {
		[self checkView:[subViews objectAt:i]];
	}
	return self;
}

-checkButton:aButton
{
	const char *title=[aButton title];

	if(title && strlen(title)==1 &&
	   [aButton tag] != 0x0c) {
		[keyTable insertKey:(void *)NXToLower(title[0])
		 value:aButton];
		[keyTable insertKey:(void *)NXToUpper(title[0])
		 value:aButton];
	}
	return self;
}

-checkMatrix:aMatrix
{
	id cellList=[aMatrix cellList];
	int numCells=[cellList count];
	int i;

	for(i=0;i<numCells;i++) {
		[self checkButton:[cellList objectAt:i]];
	}
	return self;
}

-keyDown:(NXEvent *)theEvent
{
	id button;

	button=[keyTable valueForKey:
			(void *)(int)theEvent->data.key.charCode];

	if(button) {
		return [button performClick:self];
	}
	return [super keyDown:theEvent];
}

-initContent:(const NXRect *)contentRect
style:(int)aStyle
backing:(int)bufferingType
buttonMask:(int)mask
defer:(BOOL)flag
{
	keyTable=[[HashTable alloc] initKeyDesc:"i"];
	return [super initContent:contentRect
			style:aStyle
			backing:bufferingType
			buttonMask:mask
			defer:flag];
}

@end
